/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.storage.pathmapped.metrics;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.commonjava.o11yphant.metrics.MetricsManager;
import org.commonjava.o11yphant.metrics.util.NameUtils;
import org.commonjava.storage.pathmapped.model.PathMap;
import org.commonjava.storage.pathmapped.model.Reclaim;
import org.commonjava.storage.pathmapped.spi.PathDB;

public class MeasuredPathDB
implements PathDB {
    private final PathDB decorated;
    private final MetricsManager metricsManager;
    private final String metricPrefix;

    public MeasuredPathDB(PathDB decorated, MetricsManager metricsManager, String metricPrefix) {
        this.decorated = decorated;
        this.metricsManager = metricsManager;
        this.metricPrefix = metricPrefix;
    }

    public List<PathMap> list(String fileSystem, String path, PathDB.FileType fileType) {
        return this.measure(() -> this.decorated.list(fileSystem, path, fileType), "list");
    }

    public List<PathMap> list(String fileSystem, String path, boolean recursive, int limit, PathDB.FileType fileType) {
        return this.measure(() -> this.decorated.list(fileSystem, path, recursive, limit, fileType), "listRecursively");
    }

    public PathMap getPathMap(String fileSystem, String path) {
        return this.measure(() -> this.decorated.getPathMap(fileSystem, path), "getPathMap");
    }

    public long getFileLength(String fileSystem, String path) {
        return this.measure(() -> this.decorated.getFileLength(fileSystem, path), "getFileLength");
    }

    public long getFileLastModified(String fileSystem, String path) {
        return this.measure(() -> this.decorated.getFileLastModified(fileSystem, path), "getFileLastModified");
    }

    public PathDB.FileType exists(String fileSystem, String path) {
        return this.measure(() -> this.decorated.exists(fileSystem, path), "exists");
    }

    public boolean existsFile(String fileSystem, String path) {
        return this.measure(() -> this.decorated.existsFile(fileSystem, path), "existsFile");
    }

    public void insert(String fileSystem, String path, Date creation, Date expiration, String fileId, long size, String fileStorage, String checksum) {
        this.measure(() -> this.decorated.insert(fileSystem, path, creation, expiration, fileId, size, fileStorage, checksum), "insert");
    }

    public boolean isDirectory(String fileSystem, String path) {
        return this.measure(() -> this.decorated.isDirectory(fileSystem, path), "isDirectory");
    }

    public boolean isFile(String fileSystem, String path) {
        return this.measure(() -> this.decorated.isFile(fileSystem, path), "isFile");
    }

    public boolean delete(String fileSystem, String path) {
        return this.measure(() -> this.decorated.delete(fileSystem, path), "delete");
    }

    public Set<String> getFileSystemContaining(Collection<String> candidates, String path) {
        return this.measure(() -> this.decorated.getFileSystemContaining(candidates, path), "getFileSystemContaining");
    }

    public String getFirstFileSystemContaining(List<String> candidates, String path) {
        return this.measure(() -> this.decorated.getFirstFileSystemContaining(candidates, path), "getFirstFileSystemContaining");
    }

    public void traverse(String fileSystem, String path, Consumer<PathMap> consumer, int limit, PathDB.FileType fileType) {
        this.measure(() -> this.decorated.traverse(fileSystem, path, consumer, limit, fileType), "traverse");
    }

    public String getStorageFile(String fileSystem, String path) {
        return this.measure(() -> this.decorated.getStorageFile(fileSystem, path), "getStorageFile");
    }

    public boolean copy(String fromFileSystem, String fromPath, String toFileSystem, String toPath) {
        return this.measure(() -> this.decorated.copy(fromFileSystem, fromPath, toFileSystem, toPath), "copy");
    }

    public void makeDirs(String fileSystem, String path) {
        this.measure(() -> this.decorated.makeDirs(fileSystem, path), "makeDirs");
    }

    public List<Reclaim> listOrphanedFiles(int limit) {
        return this.measure(() -> this.decorated.listOrphanedFiles(limit), "listOrphanedFiles");
    }

    public void removeFromReclaim(Reclaim reclaim) {
        this.decorated.removeFromReclaim(reclaim);
    }

    private void measure(Runnable runnable, String metricName) {
        if (this.metricsManager != null && this.isMetricEnabled(metricName)) {
            this.metricsManager.wrapWithStandardMetrics(() -> {
                runnable.run();
                return null;
            }, () -> NameUtils.name((String)this.metricPrefix, (String[])new String[]{metricName}));
        } else {
            runnable.run();
        }
    }

    private <T> T measure(Supplier<T> methodSupplier, String metricName) {
        if (this.metricsManager != null && this.isMetricEnabled(metricName)) {
            return (T)this.metricsManager.wrapWithStandardMetrics(methodSupplier, () -> NameUtils.name((String)this.metricPrefix, (String[])new String[]{metricName}));
        }
        return methodSupplier.get();
    }

    protected boolean isMetricEnabled(String metricName) {
        return true;
    }
}

