/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.storage.pathmapped.metrics;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.commonjava.storage.pathmapped.model.PathMap;
import org.commonjava.storage.pathmapped.model.Reclaim;
import org.commonjava.storage.pathmapped.spi.PathDB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeasuredPathDB
implements PathDB {
    private final PathDB decorated;
    private final MetricRegistry metricRegistry;
    private final String metricPrefix;
    private static final String TIMER = "timer";

    public MeasuredPathDB(PathDB decorated, MetricRegistry metricRegistry, String metricPrefix) {
        this.decorated = decorated;
        this.metricRegistry = metricRegistry;
        this.metricPrefix = metricPrefix;
    }

    public List<PathMap> list(String fileSystem, String path, PathDB.FileType fileType) {
        return this.measure(() -> this.decorated.list(fileSystem, path, fileType), "list");
    }

    public List<PathMap> list(String fileSystem, String path, boolean recursive, int limit, PathDB.FileType fileType) {
        return this.measure(() -> this.decorated.list(fileSystem, path, recursive, limit, fileType), "listRecursively");
    }

    public long getFileLength(String fileSystem, String path) {
        return this.measure(() -> this.decorated.getFileLength(fileSystem, path), "getFileLength");
    }

    public long getFileLastModified(String fileSystem, String path) {
        return this.measure(() -> this.decorated.getFileLastModified(fileSystem, path), "getFileLastModified");
    }

    public PathDB.FileType exists(String fileSystem, String path) {
        return this.measure(() -> this.decorated.exists(fileSystem, path), "exists");
    }

    public void insert(String fileSystem, String path, Date creation, Date expiration, String fileId, long size, String fileStorage, String checksum) {
        this.measure(() -> this.decorated.insert(fileSystem, path, creation, expiration, fileId, size, fileStorage, checksum), "insert");
    }

    public boolean isDirectory(String fileSystem, String path) {
        return this.measure(() -> this.decorated.isDirectory(fileSystem, path), "isDirectory");
    }

    public boolean isFile(String fileSystem, String path) {
        return this.measure(() -> this.decorated.isFile(fileSystem, path), "isFile");
    }

    public boolean delete(String fileSystem, String path) {
        return this.measure(() -> this.decorated.delete(fileSystem, path), "delete");
    }

    public Set<String> getFileSystemContaining(Collection<String> candidates, String path) {
        return this.measure(() -> this.decorated.getFileSystemContaining(candidates, path), "getFileSystemContaining");
    }

    public String getFirstFileSystemContaining(List<String> candidates, String path) {
        return this.measure(() -> this.decorated.getFirstFileSystemContaining(candidates, path), "getFirstFileSystemContaining");
    }

    public String getStorageFile(String fileSystem, String path) {
        return this.measure(() -> this.decorated.getStorageFile(fileSystem, path), "getStorageFile");
    }

    public boolean copy(String fromFileSystem, String fromPath, String toFileSystem, String toPath) {
        return this.measure(() -> this.decorated.copy(fromFileSystem, fromPath, toFileSystem, toPath), "copy");
    }

    public void makeDirs(String fileSystem, String path) {
        this.measure(() -> this.decorated.makeDirs(fileSystem, path), "makeDirs");
    }

    public List<Reclaim> listOrphanedFiles(int limit) {
        return this.measure(() -> this.decorated.listOrphanedFiles(limit), "listOrphanedFiles");
    }

    public void removeFromReclaim(Reclaim reclaim) {
        this.decorated.removeFromReclaim(reclaim);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void measure(Runnable runnable, String metricName) {
        if (this.metricRegistry != null && this.isMetricEnabled(metricName)) {
            Timer.Context context = this.metricRegistry.timer(MetricRegistry.name((String)this.metricPrefix, (String[])new String[]{metricName, TIMER})).time();
            try {
                runnable.run();
            }
            finally {
                context.stop();
            }
        } else {
            runnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T measure(Callable<T> callable, String metricName) {
        try {
            if (this.metricRegistry == null) return callable.call();
            if (!this.isMetricEnabled(metricName)) return callable.call();
            Timer.Context context = this.metricRegistry.timer(MetricRegistry.name((String)this.metricPrefix, (String[])new String[]{metricName, TIMER})).time();
            try {
                T t = callable.call();
                return t;
            }
            finally {
                context.stop();
            }
        }
        catch (Exception e) {
            Logger logger = LoggerFactory.getLogger(this.getClass());
            logger.warn("Call failed", (Throwable)e);
            return null;
        }
    }

    protected boolean isMetricEnabled(String metricName) {
        return true;
    }
}

