/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.storage.pathmapped.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.commonjava.storage.pathmapped.spi.FileInfo;
import org.commonjava.storage.pathmapped.spi.PhysicalStore;
import org.commonjava.storage.pathmapped.util.PathMapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedPhysicalStore
implements PhysicalStore {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final File baseDir;
    private static final int LEVEL_1_DIR_LENGTH = 2;
    private static final int LEVEL_2_DIR_LENGTH = 2;
    private static final int DIR_LENGTH = 4;

    public FileBasedPhysicalStore(File baseDir) {
        this.baseDir = baseDir;
    }

    public FileInfo getFileInfo(String fileSystem, String path) {
        String id = PathMapUtils.getRandomFileId();
        String dir = this.getStorageDir(id);
        FileInfo fileInfo = new FileInfo();
        fileInfo.setFileId(id);
        fileInfo.setFileStorage(Paths.get(dir, id).toString());
        return fileInfo;
    }

    private String getStorageDir(String fileId) {
        String folder = fileId.substring(0, 2);
        String subFolder = fileId.substring(2, 4);
        return folder + "/" + subFolder;
    }

    public OutputStream getOutputStream(FileInfo fileInfo) throws IOException {
        File f = new File(this.baseDir, fileInfo.getFileStorage());
        File dir = f.getParentFile();
        if (!dir.isDirectory()) {
            dir.mkdirs();
        }
        return new FileOutputStream(f);
    }

    public InputStream getInputStream(String storageFile) throws IOException {
        File f = new File(this.baseDir, storageFile);
        if (f.isDirectory() || !f.exists()) {
            this.logger.debug("Target file not exists, file: {}", (Object)f.getAbsolutePath());
            return null;
        }
        return new FileInputStream(f);
    }

    public boolean delete(FileInfo fileInfo) {
        File f = new File(this.baseDir, fileInfo.getFileStorage());
        try {
            Files.deleteIfExists(Paths.get(f.getAbsolutePath(), new String[0]));
        }
        catch (IOException e) {
            this.logger.error("Failed to delete file: " + fileInfo, (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean exists(String storageFile) {
        if (storageFile == null) {
            return false;
        }
        return new File(this.baseDir, storageFile).exists();
    }
}

