/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.o11yphant.metrics.conf;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusConfig {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, Boolean> expressedCache = new ConcurrentHashMap<String, Boolean>();
    private List<String> expressedMetrics;
    private String nodeLabel;
    private final Function<String, Boolean> lookupFunction = name -> this.expressedMetrics != null && this.expressedMetrics.stream().anyMatch(n -> {
        String pname = n.replace('.', '_');
        if (name.equals(n) || name.contains((CharSequence)n) || name.matches((String)n) || pname.equals(name) || pname.contains((CharSequence)name)) {
            this.logger.trace("ACCEPT metric: {} for expression: {}", name, n);
            return true;
        }
        this.logger.trace("REJECT metric: {} for expression: {}", name, n);
        return false;
    });

    public List<String> getExpressedMetrics() {
        return this.expressedMetrics;
    }

    public void setExpressedMetrics(List<String> expressedMetrics) {
        this.expressedMetrics = expressedMetrics;
    }

    public boolean isMetricExpressed(String metricName) {
        return this.expressedCache.computeIfAbsent(metricName, this.lookupFunction);
    }

    public String getNodeLabel() {
        return this.nodeLabel;
    }

    public void setNodeLabel(String nodeLabel) {
        this.nodeLabel = nodeLabel;
    }
}

