/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.httprox.util;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpRequest;
import org.commonjava.indy.IndyWorkflowException;
import org.commonjava.indy.audit.ChangeSummary;
import org.commonjava.indy.bind.jaxrs.RequestContextHelper;
import org.commonjava.indy.core.ctl.ContentController;
import org.commonjava.indy.data.ArtifactStoreQuery;
import org.commonjava.indy.data.IndyDataException;
import org.commonjava.indy.data.StoreDataManager;
import org.commonjava.indy.folo.model.TrackingKey;
import org.commonjava.indy.httprox.conf.HttproxConfig;
import org.commonjava.indy.httprox.handler.AbstractProxyRepositoryCreator;
import org.commonjava.indy.httprox.handler.ProxyCreationResult;
import org.commonjava.indy.httprox.handler.ProxyRepositoryCreator;
import org.commonjava.indy.httprox.util.HttpConduitWrapper;
import org.commonjava.indy.metrics.conf.IndyMetricsConfig;
import org.commonjava.indy.model.core.AccessChannel;
import org.commonjava.indy.model.core.ArtifactStore;
import org.commonjava.indy.model.core.Group;
import org.commonjava.indy.model.core.HostedRepository;
import org.commonjava.indy.model.core.RemoteRepository;
import org.commonjava.indy.model.core.StoreType;
import org.commonjava.indy.subsys.http.util.UserPass;
import org.commonjava.indy.util.ApplicationHeader;
import org.commonjava.indy.util.ApplicationStatus;
import org.commonjava.indy.util.UrlInfo;
import org.commonjava.maven.galley.TransferException;
import org.commonjava.maven.galley.event.EventMetadata;
import org.commonjava.maven.galley.model.Transfer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyResponseHelper {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String TRACKED_USER_SUFFIX = "+tracking";
    private final HttpRequest httpRequest;
    private final ProxyRepositoryCreator repoCreator;
    private final StoreDataManager storeManager;
    private final IndyMetricsConfig metricsConfig;
    private final MetricRegistry metricRegistry;
    private final String cls;
    private final HttproxConfig config;
    private final ContentController contentController;
    private boolean transferred;

    public ProxyResponseHelper(HttpRequest httpRequest, HttproxConfig config, ContentController contentController, ProxyRepositoryCreator repoCreator, StoreDataManager storeManager, IndyMetricsConfig metricsConfig, MetricRegistry metricRegistry, String cls) {
        this.httpRequest = httpRequest;
        this.config = config;
        this.contentController = contentController;
        this.repoCreator = repoCreator;
        this.storeManager = storeManager;
        this.metricsConfig = metricsConfig;
        this.metricRegistry = metricRegistry;
        this.cls = cls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArtifactStore getArtifactStore(String trackingId, URL url) throws IndyDataException {
        ArtifactStore store = null;
        if (this.metricsConfig == null || this.metricRegistry == null) {
            store = this.doGetArtifactStore(trackingId, url);
        }
        if (store == null) {
            Timer timer = this.metricRegistry.timer(MetricRegistry.name((String)this.metricsConfig.getNodePrefix(), (String[])new String[]{this.cls, "getArtifactStore"}));
            Timer.Context timerContext = timer.time();
            try {
                store = this.doGetArtifactStore(trackingId, url);
            }
            finally {
                timerContext.stop();
            }
        }
        RequestContextHelper.setContext((String)"package-type", (String)store.getKey().getPackageType());
        RequestContextHelper.setContext((String)"content-entry-point", (String)store.getKey().toString());
        return store;
    }

    private ArtifactStore doGetArtifactStore(String trackingId, URL url) throws IndyDataException {
        int port = this.getPort(url);
        if (trackingId != null) {
            String groupName = this.repoCreator.formatId(url.getHost(), port, 0, trackingId, StoreType.group);
            ArtifactStoreQuery query = this.storeManager.query().packageType("generic-http").storeType(Group.class);
            Group group = query.getGroup(groupName);
            this.logger.debug("Get httproxy group, group: {}", (Object)group);
            if (group == null) {
                this.logger.debug("Creating repositories (group, hosted, remote) for HTTProx request: {}, trackingId: {}", (Object)url, (Object)trackingId);
                ProxyCreationResult result = this.createRepo(trackingId, url, null);
                group = result.getGroup();
            }
            return group;
        }
        String baseUrl = this.getBaseUrl(url, false);
        ArtifactStoreQuery query = this.storeManager.query().packageType("generic-http").storeType(RemoteRepository.class);
        RemoteRepository remote = query.stream().filter(store -> store.getUrl().equals(baseUrl) && store.getMetadata("trackingId") == null).findFirst().orElse(null);
        this.logger.debug("Get httproxy remote, remote: {}", (Object)remote);
        if (remote == null) {
            this.logger.debug("Creating remote repository for HTTProx request: {}", (Object)url);
            String name = this.getRemoteRepositoryName(url);
            ProxyCreationResult result = this.createRepo(null, url, name);
            remote = result.getRemote();
        }
        return remote;
    }

    private ProxyCreationResult createRepo(String trackingId, URL url, String name) throws IndyDataException {
        Group group;
        HostedRepository hosted;
        UrlInfo info = new UrlInfo(url.toExternalForm());
        UserPass up = UserPass.parse((ApplicationHeader)ApplicationHeader.authorization, (HttpRequest)this.httpRequest, (String)url.getAuthority());
        String baseUrl = this.getBaseUrl(url, false);
        this.logger.debug(">>>> Create repo: trackingId=" + trackingId + ", name=" + name);
        ProxyCreationResult result = this.repoCreator.create(trackingId, name, baseUrl, info, up, LoggerFactory.getLogger(this.repoCreator.getClass()));
        ChangeSummary changeSummary = new ChangeSummary("system", "Creating HTTProx proxy for: " + info.getUrl());
        RemoteRepository remote = result.getRemote();
        if (remote != null) {
            this.storeManager.storeArtifactStore((ArtifactStore)remote, changeSummary, false, true, new EventMetadata());
        }
        if ((hosted = result.getHosted()) != null) {
            this.storeManager.storeArtifactStore((ArtifactStore)hosted, changeSummary, false, true, new EventMetadata());
        }
        if ((group = result.getGroup()) != null) {
            this.storeManager.storeArtifactStore((ArtifactStore)group, changeSummary, false, true, new EventMetadata());
        }
        return result;
    }

    private String getRemoteRepositoryName(URL url) throws IndyDataException {
        String name = this.repoCreator.formatId(url.getHost(), this.getPort(url), 0, null, StoreType.remote);
        this.logger.debug("Looking for remote repo starts with name: {}", (Object)name);
        AbstractProxyRepositoryCreator abstractProxyRepositoryCreator = null;
        if (this.repoCreator instanceof AbstractProxyRepositoryCreator) {
            abstractProxyRepositoryCreator = (AbstractProxyRepositoryCreator)this.repoCreator;
        }
        if (abstractProxyRepositoryCreator == null) {
            return name;
        }
        Predicate<ArtifactStore> filter = abstractProxyRepositoryCreator.getNameFilter(name);
        List<String> l = this.storeManager.query().packageType("generic-http").storeType(RemoteRepository.class).stream(filter).map(repository -> repository.getName()).collect(Collectors.toList());
        if (l.isEmpty()) {
            return name;
        }
        return abstractProxyRepositoryCreator.getNextName(l);
    }

    private int getPort(URL url) {
        int port = url.getPort();
        if (port < 1) {
            port = url.getDefaultPort();
        }
        return port;
    }

    private String getBaseUrl(URL url, boolean includeDefaultPort) {
        int port = this.getPort(url);
        String portStr = includeDefaultPort || port != url.getDefaultPort() ? ":" + port : "";
        return String.format("%s://%s%s/", url.getProtocol(), url.getHost(), portStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transfer(HttpConduitWrapper http, ArtifactStore store, String path, boolean writeBody, UserPass proxyUserPass) throws IOException, IndyWorkflowException {
        RequestContextHelper.setContext((String)"path", (String)path);
        RequestContextHelper.setContext((String)"metadata-content", (String)Boolean.toString(false));
        if (this.metricsConfig == null || this.metricRegistry == null) {
            this.doTransfer(http, store, path, writeBody, proxyUserPass);
            return;
        }
        Timer timer = this.metricRegistry.timer(MetricRegistry.name((String)this.metricsConfig.getNodePrefix(), (String[])new String[]{this.cls, "transfer"}));
        Timer.Context timerContext = timer.time();
        try {
            this.doTransfer(http, store, path, writeBody, proxyUserPass);
        }
        finally {
            timerContext.stop();
        }
    }

    private void doTransfer(HttpConduitWrapper http, ArtifactStore store, String path, boolean writeBody, UserPass proxyUserPass) throws IOException, IndyWorkflowException {
        if (this.transferred) {
            return;
        }
        this.transferred = true;
        if (!http.isOpen()) {
            throw new IOException("Sink channel already closed (or null)!");
        }
        EventMetadata eventMetadata = this.createEventMetadata(writeBody, proxyUserPass, path, store);
        Transfer txfr = null;
        try {
            txfr = this.contentController.get(store.getKey(), path, eventMetadata);
        }
        catch (IndyWorkflowException e) {
            if (!(e.getCause() instanceof TransferException)) {
                throw e;
            }
            this.logger.debug("Suppressed exception for further handling inside proxy logic:", (Throwable)e);
        }
        if (txfr != null && txfr.exists()) {
            http.writeExistingTransfer(txfr, writeBody, path, eventMetadata);
        } else {
            http.writeNotFoundTransfer(store, path);
        }
    }

    private EventMetadata createEventMetadata(boolean writeBody, UserPass proxyUserPass, String path, ArtifactStore store) throws IndyWorkflowException {
        EventMetadata eventMetadata = new EventMetadata();
        if (writeBody) {
            TrackingKey tk = this.getTrackingKey(proxyUserPass);
            if (tk != null) {
                this.logger.debug("TRACKING {} in {} (KEY: {})", new Object[]{path, store, tk});
                eventMetadata.set((Object)"tracking-id", (Object)tk);
                eventMetadata.set((Object)"access-channel", (Object)AccessChannel.GENERIC_PROXY);
            } else {
                this.logger.debug("NOT TRACKING: {} in {}", (Object)path, (Object)store);
            }
        } else {
            this.logger.debug("NOT TRACKING non-body request: {} in {}", (Object)path, (Object)store);
        }
        eventMetadata.setPackageType("generic-http");
        return eventMetadata;
    }

    public TrackingKey getTrackingKey(UserPass proxyUserPass) throws IndyWorkflowException {
        TrackingKey tk = null;
        switch (this.config.getTrackingType()) {
            case ALWAYS: {
                if (proxyUserPass == null) {
                    throw new IndyWorkflowException(ApplicationStatus.BAD_REQUEST.code(), "Tracking is always-on, but no username was provided! Cannot initialize tracking key.", new Object[0]);
                }
                tk = new TrackingKey(proxyUserPass.getUser());
                break;
            }
            case SUFFIX: {
                String user;
                if (proxyUserPass == null || (user = proxyUserPass.getUser()) == null || !user.endsWith(TRACKED_USER_SUFFIX) || user.length() <= TRACKED_USER_SUFFIX.length()) break;
                tk = new TrackingKey(StringUtils.substring((String)user, (int)0, (int)(-TRACKED_USER_SUFFIX.length())));
                break;
            }
        }
        return tk;
    }
}

