/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.httprox.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.commonjava.indy.IndyWorkflowException;
import org.commonjava.indy.bind.jaxrs.RequestContextHelper;
import org.commonjava.indy.core.ctl.ContentController;
import org.commonjava.indy.httprox.util.ChannelUtils;
import org.commonjava.indy.model.core.ArtifactStore;
import org.commonjava.indy.model.util.HttpUtils;
import org.commonjava.indy.subsys.http.HttpWrapper;
import org.commonjava.indy.util.ApplicationHeader;
import org.commonjava.indy.util.ApplicationStatus;
import org.commonjava.maven.galley.event.EventMetadata;
import org.commonjava.maven.galley.model.Transfer;
import org.commonjava.maven.galley.spi.cache.CacheProvider;
import org.commonjava.maven.galley.transport.htcli.model.HttpExchangeMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.channels.StreamSinkChannel;

public class HttpConduitWrapper
implements HttpWrapper {
    private final StreamSinkChannel sinkChannel;
    private HttpRequest httpRequest;
    private final ContentController contentController;
    private CacheProvider cacheProvider;

    public HttpConduitWrapper(StreamSinkChannel channel, HttpRequest httpRequest, ContentController contentController, CacheProvider cacheProvider) {
        this.sinkChannel = channel;
        this.httpRequest = httpRequest;
        this.contentController = contentController;
        this.cacheProvider = cacheProvider;
    }

    public void writeError(Throwable e) throws IOException {
        String message = String.format("%s:\n  %s", e.getMessage(), StringUtils.join((Object[])e.getStackTrace(), (String)"\n  "));
        this.sinkChannel.write(ByteBuffer.wrap(message.getBytes()));
    }

    public void writeHeader(ApplicationHeader header, String value) throws IOException {
        ByteBuffer b = ByteBuffer.wrap(String.format("%s: %s\r\n", header.key(), value).getBytes());
        this.sinkChannel.write(b);
    }

    public void writeHeader(String header, String value) throws IOException {
        ByteBuffer b = ByteBuffer.wrap(String.format("%s: %s\r\n", header, value).getBytes());
        this.sinkChannel.write(b);
    }

    public void writeStatus(ApplicationStatus status) throws IOException {
        RequestContextHelper.setContext((String)"http-status", (String)String.valueOf(status.code()));
        ByteBuffer b = ByteBuffer.wrap(String.format("HTTP/1.1 %d %s\r\n", status.code(), status.message()).getBytes());
        this.sinkChannel.write(b);
    }

    public void writeStatus(int code, String message) throws IOException {
        RequestContextHelper.setContext((String)"http-status", (String)String.valueOf(code));
        ByteBuffer b = ByteBuffer.wrap(String.format("HTTP/1.1 %d %s\r\n", code, message).getBytes());
        this.sinkChannel.write(b);
    }

    private void writeClose() throws IOException {
        this.writeHeader("Connection", "close\r\n");
    }

    public void writeNotFoundTransfer(ArtifactStore store, String path) throws IOException, IndyWorkflowException {
        Logger logger = LoggerFactory.getLogger(this.getClass());
        logger.debug("No transfer found.");
        HttpExchangeMetadata metadata = this.contentController.getHttpMetadata(store.getKey(), path);
        if (metadata == null) {
            logger.debug("No transfer metadata.");
            this.writeStatus(ApplicationStatus.NOT_FOUND);
        } else {
            logger.debug("Writing metadata from http exchange with upstream.");
            if (metadata.getResponseStatusCode() == 500) {
                logger.debug("Translating 500 error upstream into 502");
                this.writeStatus(502, "Bad Gateway");
            } else {
                logger.debug("Passing through upstream status: " + metadata.getResponseStatusCode());
                this.writeStatus(metadata.getResponseStatusCode(), metadata.getResponseStatusMessage());
            }
            String contentType = metadata.getContentType();
            this.writeHeader(ApplicationHeader.content_type, contentType != null ? contentType : this.contentController.getContentType(path));
            for (Map.Entry headerSet : metadata.getResponseHeaders().entrySet()) {
                String key = (String)headerSet.getKey();
                if (ApplicationHeader.content_type.upperKey().equals(key)) continue;
                for (String value : (List)headerSet.getValue()) {
                    this.writeHeader((String)headerSet.getKey(), value);
                }
            }
        }
        this.writeClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExistingTransfer(Transfer txfr, boolean writeBody, String path, EventMetadata eventMetadata) throws IOException, IndyWorkflowException {
        Logger logger = LoggerFactory.getLogger(this.getClass());
        logger.debug("Valid transfer found, {}", (Object)txfr);
        try (InputStream in = txfr.openInputStream(true, eventMetadata);){
            String contentType;
            String lastMod;
            long bytes;
            HttpExchangeMetadata metadata = this.contentController.getHttpMetadata(txfr);
            logger.trace("Got HTTP metadata: {} for transfer: {}", (Object)metadata, (Object)txfr);
            this.writeStatus(ApplicationStatus.OK);
            Long headerContentLength = metadata != null ? metadata.getContentLength() : null;
            long l = bytes = metadata != null && headerContentLength != null ? metadata.getContentLength().longValue() : txfr.length();
            if (bytes < 1L) {
                bytes = txfr.length();
            }
            if (bytes > 0L) {
                this.writeHeader(ApplicationHeader.content_length, String.valueOf(bytes));
            }
            String string = lastMod = metadata != null ? metadata.getLastModified() : null;
            if (lastMod == null) {
                lastMod = HttpUtils.formatDateHeader((long)txfr.lastModified());
            }
            if (lastMod != null) {
                this.writeHeader(ApplicationHeader.last_modified, lastMod);
            }
            this.writeHeader(ApplicationHeader.content_type, (contentType = metadata.getContentType()) != null ? contentType : this.contentController.getContentType(path));
            logger.trace("Write body, {}", (Object)writeBody);
            if (writeBody) {
                this.sinkChannel.write(ByteBuffer.wrap("\r\n".getBytes()));
                int capacity = 32768;
                ByteBuffer bbuf = ByteBuffer.allocate(capacity);
                byte[] buf = new byte[capacity];
                int read = -1;
                logger.trace("Read transfer...");
                while ((read = in.read(buf)) > -1) {
                    logger.trace("Read transfer and write to channel, size: {}", (Object)read);
                    bbuf.clear();
                    bbuf.put(buf, 0, read);
                    bbuf.flip();
                    ChannelUtils.write((WritableByteChannel)this.sinkChannel, bbuf);
                }
            }
        }
        finally {
            this.cacheProvider.cleanupCurrentThread();
        }
        this.sinkChannel.flush();
        logger.debug("Write transfer DONE.");
    }

    public boolean isOpen() {
        return this.sinkChannel != null && this.sinkChannel.isOpen();
    }

    public List<String> getHeaders(String name) {
        Header[] headers;
        ArrayList<String> result = new ArrayList<String>();
        for (Header header : headers = this.httpRequest.getHeaders(name)) {
            result.add(header.getValue());
        }
        return result;
    }

    public void close() throws IOException {
        ChannelUtils.flush(this.sinkChannel);
        this.sinkChannel.shutdownWrites();
    }
}

