/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.httprox.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.commonjava.indy.httprox.util.CertificateAndKeys;
import sun.security.x509.AlgorithmId;
import sun.security.x509.BasicConstraintsExtension;
import sun.security.x509.CertificateAlgorithmId;
import sun.security.x509.CertificateExtensions;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateValidity;
import sun.security.x509.CertificateVersion;
import sun.security.x509.CertificateX509Key;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

public class CertUtils {
    public static final String DEFAULT_SIGN_ALGORITHM = "SHA256withRSA";
    public static final String KEY_TYPE_RSA = "RSA";
    public static final String CERT_TYPE_X509 = "X.509";
    public static final int DEFAULT_CERT_EXPIRATION_DAYS = 365;

    public static X509Certificate generateX509Certificate(KeyPair pair, String dn, int days, String algorithm) throws GeneralSecurityException, IOException {
        PrivateKey privateKey = pair.getPrivate();
        X509CertInfo info = new X509CertInfo();
        Date from = new Date();
        Date to = new Date(from.getTime() + TimeUnit.DAYS.toMillis(days));
        CertificateValidity interval = new CertificateValidity(from, to);
        BigInteger sn = new BigInteger(64, new SecureRandom());
        X500Name owner = new X500Name(dn);
        info.set("validity", interval);
        info.set("serialNumber", new CertificateSerialNumber(sn));
        info.set("subject", owner);
        info.set("issuer", owner);
        info.set("key", new CertificateX509Key(pair.getPublic()));
        info.set("version", new CertificateVersion(2));
        AlgorithmId algo = new AlgorithmId(AlgorithmId.sha256WithRSAEncryption_oid);
        info.set("algorithmID", new CertificateAlgorithmId(algo));
        X509CertImpl cert = new X509CertImpl(info);
        cert.sign(privateKey, algorithm);
        algo = (AlgorithmId)cert.get("x509.algorithm");
        info.set("algorithmID.algorithm", algo);
        cert = new X509CertImpl(info);
        cert.sign(privateKey, algorithm);
        return cert;
    }

    public static X509Certificate loadX509Certificate(File file) throws CertificateException, IOException {
        Certificate ca;
        CertificateFactory cf = CertificateFactory.getInstance(CERT_TYPE_X509);
        try (BufferedInputStream caInput = new BufferedInputStream(new FileInputStream(file));){
            ca = cf.generateCertificate(caInput);
        }
        return (X509Certificate)ca;
    }

    public static KeyStore createKeyStore() throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        String keyStoreType = KeyStore.getDefaultType();
        KeyStore keyStore = KeyStore.getInstance(keyStoreType);
        keyStore.load(null, null);
        return keyStore;
    }

    public static KeyStore loadKeyStore(File file, String passwd) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        String keyStoreType = KeyStore.getDefaultType();
        KeyStore keyStore = KeyStore.getInstance(keyStoreType);
        keyStore.load(new FileInputStream(file), passwd.toCharArray());
        return keyStore;
    }

    public static PrivateKey getPrivateKey(String filename) throws Exception {
        byte[] keyBytes = Files.readAllBytes(Paths.get(filename, new String[0]));
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory kf = KeyFactory.getInstance(KEY_TYPE_RSA);
        return kf.generatePrivate(spec);
    }

    public static PublicKey getPublicKey(String filename) throws Exception {
        byte[] keyBytes = Files.readAllBytes(Paths.get(filename, new String[0]));
        X509EncodedKeySpec spec = new X509EncodedKeySpec(keyBytes);
        KeyFactory kf = KeyFactory.getInstance(KEY_TYPE_RSA);
        return kf.generatePublic(spec);
    }

    public static X509Certificate createSignedCertificate(X509Certificate certificate, X509Certificate issuerCertificate, PrivateKey issuerPrivateKey, boolean isIntermediate) throws Exception {
        Principal issuer = issuerCertificate.getSubjectDN();
        String issuerSigAlg = issuerCertificate.getSigAlgName();
        byte[] inCertBytes = certificate.getTBSCertificate();
        X509CertInfo info = new X509CertInfo(inCertBytes);
        info.set("issuer", issuer);
        if (isIntermediate) {
            CertificateExtensions exts = new CertificateExtensions();
            BasicConstraintsExtension bce = new BasicConstraintsExtension(true, -1);
            exts.set("BasicConstraints", new BasicConstraintsExtension((Boolean)false, bce.getExtensionValue()));
            info.set("extensions", exts);
        }
        X509CertImpl outCert = new X509CertImpl(info);
        outCert.sign(issuerPrivateKey, issuerSigAlg);
        return outCert;
    }

    public static CertificateAndKeys createSignedCertificateAndKey(String dn, X509Certificate issuerCertificate, PrivateKey issuerPrivateKey, boolean isIntermediate) throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(KEY_TYPE_RSA);
        KeyPair pair = keyPairGenerator.generateKeyPair();
        X509Certificate cert = CertUtils.generateX509Certificate(pair, dn, 365, DEFAULT_SIGN_ALGORITHM);
        X509Certificate signedCertificate = CertUtils.createSignedCertificate(cert, issuerCertificate, issuerPrivateKey, isIntermediate);
        PublicKey publicKey = pair.getPublic();
        PrivateKey privateKey = pair.getPrivate();
        return new CertificateAndKeys(signedCertificate, privateKey, publicKey);
    }
}

