/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.httprox.keycloak;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PublicKey;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.commons.codec.binary.Base64;
import org.commonjava.indy.httprox.conf.HttproxConfig;
import org.commonjava.indy.subsys.http.HttpWrapper;
import org.commonjava.indy.subsys.http.util.UserPass;
import org.commonjava.indy.subsys.keycloak.KeycloakAuthenticator;
import org.commonjava.indy.subsys.keycloak.conf.KeycloakConfig;
import org.commonjava.indy.subsys.keycloak.util.KeycloakBearerTokenDebug;
import org.commonjava.indy.util.ApplicationHeader;
import org.commonjava.indy.util.ApplicationStatus;
import org.keycloak.RSATokenVerifier;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.adapters.rotation.HardcodedPublicKeyLocator;
import org.keycloak.adapters.rotation.PublicKeyLocator;
import org.keycloak.common.VerificationException;
import org.keycloak.representations.AccessToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class KeycloakProxyAuthenticator
implements KeycloakAuthenticator {
    private static final String TOKEN_HEADER = "TOKEN";
    @Inject
    private HttproxConfig httproxConfig;
    @Inject
    private KeycloakConfig keycloakConfig;
    private KeycloakDeployment deployment;

    protected KeycloakProxyAuthenticator() {
    }

    public KeycloakProxyAuthenticator(KeycloakConfig config, HttproxConfig httproxConfig) {
        this.keycloakConfig = config;
        this.httproxConfig = httproxConfig;
    }

    private PublicKey getHardcodedRealmKey(KeycloakDeployment deployment) {
        PublicKeyLocator l = deployment.getPublicKeyLocator();
        if (l instanceof HardcodedPublicKeyLocator) {
            return l.getPublicKey(null, null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authenticate(UserPass userPass, HttpWrapper http) throws IOException {
        Logger logger = LoggerFactory.getLogger(this.getClass());
        if (!this.keycloakConfig.isEnabled() || !this.httproxConfig.isSecured()) {
            logger.debug("Keycloak httprox translation authenticator is disabled OR httprox is running in unsecured mode. Skipping authentication.");
            return true;
        }
        KeycloakProxyAuthenticator keycloakProxyAuthenticator = this;
        synchronized (keycloakProxyAuthenticator) {
            if (this.deployment == null) {
                String jsonPath = this.keycloakConfig.getKeycloakJson();
                logger.debug("Reading keycloak deployment info from: {}", (Object)jsonPath);
                File jsonFile = new File(jsonPath);
                if (jsonFile.exists()) {
                    try (FileInputStream in = new FileInputStream(jsonFile);){
                        this.deployment = KeycloakDeploymentBuilder.build((InputStream)in);
                        logger.debug("Got public key: '{}'", (Object)this.getHardcodedRealmKey(this.deployment));
                    }
                } else {
                    logger.warn("Cannot read keycloak.json from: {}", (Object)jsonPath);
                    return false;
                }
            }
        }
        String tokenString = userPass.getPassword();
        AuthResult result = null;
        if (tokenString != null) {
            result = this.authenticateToken(http, tokenString);
        }
        if (result == null || !result.success) {
            String ts = null;
            List headers = http.getHeaders(TOKEN_HEADER);
            if (headers != null && !headers.isEmpty()) {
                ts = new String(Base64.decodeBase64((String)((String)headers.get(0))));
                result = this.authenticateToken(http, ts);
            }
        }
        if (result == null) {
            logger.info("No keycloak bearer token provided! This must either be in the password of a BASIC authentication header, or in a separate Base64-encoded header: {}", (Object)TOKEN_HEADER);
            this.sendChallengeResponse(http, null, null);
            result = new AuthResult(false);
        } else if (!result.success) {
            this.sendChallengeResponse(http, result.reason, result.description);
        }
        return result.success;
    }

    protected AuthResult authenticateToken(HttpWrapper exchange, String tokenString) throws IOException {
        AccessToken token;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        try {
            KeycloakBearerTokenDebug.debugToken((String)tokenString);
            logger.debug("Verifying token: '{}'", (Object)tokenString);
            token = RSATokenVerifier.verifyToken((String)tokenString, (PublicKey)this.getHardcodedRealmKey(this.deployment), (String)this.deployment.getRealmInfoUrl());
        }
        catch (VerificationException e) {
            logger.error("Failed to verify token", (Throwable)e);
            return new AuthResult(false, "invalid_token", e.getMessage());
        }
        if (token.getIssuedAt() < this.deployment.getNotBefore()) {
            logger.error("Stale token");
            return new AuthResult(false, "invalid_token", "Stale token");
        }
        logger.debug("Token verification succeeded!");
        return new AuthResult(true);
    }

    protected void sendChallengeResponse(HttpWrapper http, String error, String description) throws IOException {
        StringBuilder header = new StringBuilder(String.format("Basic realm=\"%s\"", this.httproxConfig.getProxyRealm()));
        if (error != null) {
            header.append(", error=\"").append(error).append("\"");
        }
        if (description != null) {
            header.append(", error_description=\"").append(description).append("\"");
        }
        String challenge = header.toString();
        ApplicationStatus stat = ApplicationStatus.PROXY_AUTHENTICATION_REQUIRED;
        http.writeStatus(stat.code(), stat.message());
        http.writeHeader(ApplicationHeader.proxy_authenticate, challenge);
    }

    private static final class AuthResult {
        private boolean success;
        private String reason;
        private String description;

        private AuthResult(boolean success, String reason, String description) {
            this.success = success;
            this.reason = reason;
            this.description = description;
        }

        private AuthResult(boolean success) {
            this.success = success;
        }
    }
}

