/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.httprox.handler;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.TimeUnit;
import org.commonjava.indy.httprox.conf.HttproxConfig;
import org.commonjava.indy.httprox.util.ChannelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.conduits.ConduitStreamSinkChannel;

public class ProxySSLTunnel
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ConduitStreamSinkChannel sinkChannel;
    private final SocketChannel socketChannel;
    private volatile boolean closed;
    private final HttproxConfig config;

    public ProxySSLTunnel(ConduitStreamSinkChannel sinkChannel, SocketChannel socketChannel, HttproxConfig config) {
        this.sinkChannel = sinkChannel;
        this.socketChannel = socketChannel;
        this.config = config;
    }

    @Override
    public void run() {
        try {
            this.pipeTargetToSinkChannel(this.sinkChannel, this.socketChannel);
        }
        catch (Exception e) {
            this.logger.error("Pipe to sink channel failed", (Throwable)e);
        }
    }

    private void pipeTargetToSinkChannel(ConduitStreamSinkChannel sinkChannel, SocketChannel targetChannel) throws IOException {
        targetChannel.socket().setSoTimeout((int)TimeUnit.MINUTES.toMillis(this.config.getMITMSoTimeoutMinutes().intValue()));
        InputStream inStream = targetChannel.socket().getInputStream();
        ReadableByteChannel wrappedChannel = Channels.newChannel(inStream);
        ByteBuffer byteBuffer = ByteBuffer.allocate(32768);
        int total = 0;
        while (true) {
            if (this.closed) {
                this.logger.debug("Tunnel closed");
                break;
            }
            int read = -1;
            try {
                read = wrappedChannel.read(byteBuffer);
            }
            catch (IOException e) {
                this.logger.debug("Read target channel breaks, {}", (Object)e.toString());
                break;
            }
            if (read <= 0) {
                this.logger.debug("Read breaks, read: {}", (Object)read);
                break;
            }
            byteBuffer.flip();
            this.logger.debug("Write to sink channel, size: {}", (Object)byteBuffer.limit());
            ChannelUtils.write((WritableByteChannel)sinkChannel, byteBuffer);
            sinkChannel.flush();
            byteBuffer.clear();
            total += read;
        }
        this.logger.debug("Write to sink channel complete, transferred: {}", (Object)total);
        ChannelUtils.flush((StreamSinkChannel)sinkChannel);
        sinkChannel.shutdownWrites();
        sinkChannel.close();
        this.closed = true;
    }

    public void write(byte[] bytes) throws IOException {
        this.socketChannel.write(ByteBuffer.wrap(bytes));
    }

    public void close() {
        try {
            this.socketChannel.close();
        }
        catch (IOException e) {
            this.logger.error("Close tunnel selector failed", (Throwable)e);
        }
    }
}

