/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.httprox.handler;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.io.IOException;
import java.net.SocketAddress;
import java.net.URL;
import java.nio.channels.SocketChannel;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.http.HttpRequest;
import org.apache.http.RequestLine;
import org.commonjava.indy.IndyWorkflowException;
import org.commonjava.indy.bind.jaxrs.MDCManager;
import org.commonjava.indy.bind.jaxrs.RequestContextHelper;
import org.commonjava.indy.core.ctl.ContentController;
import org.commonjava.indy.data.IndyDataException;
import org.commonjava.indy.data.StoreDataManager;
import org.commonjava.indy.folo.model.TrackingKey;
import org.commonjava.indy.httprox.conf.HttproxConfig;
import org.commonjava.indy.httprox.conf.TrackingType;
import org.commonjava.indy.httprox.handler.ProxyMITMSSLServer;
import org.commonjava.indy.httprox.handler.ProxyRepositoryCreator;
import org.commonjava.indy.httprox.handler.ProxyRequestReader;
import org.commonjava.indy.httprox.handler.ProxySSLTunnel;
import org.commonjava.indy.httprox.keycloak.KeycloakProxyAuthenticator;
import org.commonjava.indy.httprox.util.HttpConduitWrapper;
import org.commonjava.indy.httprox.util.HttpProxyConstants;
import org.commonjava.indy.httprox.util.ProxyResponseHelper;
import org.commonjava.indy.metrics.conf.IndyMetricsConfig;
import org.commonjava.indy.model.core.ArtifactStore;
import org.commonjava.indy.sli.metrics.GoldenSignalsMetricSet;
import org.commonjava.indy.subsys.http.HttpWrapper;
import org.commonjava.indy.subsys.http.util.UserPass;
import org.commonjava.indy.subsys.infinispan.CacheHandle;
import org.commonjava.indy.subsys.infinispan.CacheProducer;
import org.commonjava.indy.util.ApplicationHeader;
import org.commonjava.indy.util.ApplicationStatus;
import org.commonjava.maven.galley.spi.cache.CacheProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.xnio.ChannelListener;
import org.xnio.StreamConnection;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.conduits.ConduitStreamSinkChannel;
import org.xnio.conduits.ConduitStreamSourceChannel;

public final class ProxyResponseWriter
implements ChannelListener<ConduitStreamSinkChannel> {
    private static final String HTTP_PROXY_AUTH_CACHE = "httproxy-auth-cache";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Logger restLogger = LoggerFactory.getLogger((String)"org.commonjava.topic.httprox.inbound");
    private final ConduitStreamSourceChannel sourceChannel;
    private ProxyRequestReader proxyRequestReader;
    private final SocketAddress peerAddress;
    private ProxySSLTunnel sslTunnel;
    private boolean directed = false;
    private final CacheHandle<String, Boolean> proxyAuthCache;
    private Throwable error;
    private final HttproxConfig config;
    private final ContentController contentController;
    private final StoreDataManager storeManager;
    private KeycloakProxyAuthenticator proxyAuthenticator;
    private CacheProvider cacheProvider;
    private ProxyRepositoryCreator repoCreator;
    private HttpRequest httpRequest;
    private final MDCManager mdcManager;
    private final MetricRegistry metricRegistry;
    private GoldenSignalsMetricSet sliMetricSet;
    private long startNanos;
    private final IndyMetricsConfig metricsConfig;
    private final String cls;
    private final ThreadPoolExecutor tunnelAndMITMExecutor = (ThreadPoolExecutor)Executors.newCachedThreadPool();

    public ProxyResponseWriter(HttproxConfig config, StoreDataManager storeManager, ContentController contentController, KeycloakProxyAuthenticator proxyAuthenticator, CacheProvider cacheProvider, MDCManager mdcManager, ProxyRepositoryCreator repoCreator, StreamConnection accepted, IndyMetricsConfig metricsConfig, MetricRegistry metricRegistry, GoldenSignalsMetricSet sliMetricSet, CacheProducer cacheProducer, long start) {
        this.config = config;
        this.contentController = contentController;
        this.storeManager = storeManager;
        this.proxyAuthenticator = proxyAuthenticator;
        this.cacheProvider = cacheProvider;
        this.mdcManager = mdcManager;
        this.repoCreator = repoCreator;
        this.peerAddress = accepted.getPeerAddress();
        this.sourceChannel = accepted.getSourceChannel();
        this.metricsConfig = metricsConfig;
        this.metricRegistry = metricRegistry;
        this.sliMetricSet = sliMetricSet;
        this.startNanos = start;
        this.cls = ClassUtils.getAbbreviatedName((String)this.getClass().getName(), (int)1);
        this.proxyAuthCache = cacheProducer.getCache(HTTP_PROXY_AUTH_CACHE);
    }

    public void setProxyRequestReader(ProxyRequestReader proxyRequestReader) {
        this.proxyRequestReader = proxyRequestReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(ConduitStreamSinkChannel channel) {
        if (this.metricsConfig == null || this.metricRegistry == null) {
            this.doHandleEvent(channel);
            return;
        }
        Timer timer = this.metricRegistry.timer(MetricRegistry.name((String)this.metricsConfig.getNodePrefix(), (String[])new String[]{this.cls, "handleEvent"}));
        Timer.Context timerContext = timer.time();
        try {
            this.doHandleEvent(channel);
        }
        finally {
            timerContext.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doHandleEvent(ConduitStreamSinkChannel sinkChannel) {
        if (this.directed) {
            return;
        }
        HttpConduitWrapper http = new HttpConduitWrapper((StreamSinkChannel)sinkChannel, this.httpRequest, this.contentController, this.cacheProvider);
        if (this.httpRequest == null) {
            if (this.error != null) {
                this.logger.debug("Handling error from request reader: " + this.error.getMessage(), this.error);
                this.handleError(this.error, http);
            } else {
                this.logger.debug("Invalid state (no error or request) from request reader. Sending 400.");
                try {
                    http.writeStatus(ApplicationStatus.BAD_REQUEST);
                }
                catch (IOException e) {
                    this.logger.error("Failed to write BAD REQUEST for missing HTTP first-line to response channel.", (Throwable)e);
                }
            }
            return;
        }
        this.restLogger.info("SERVE {} (from: {})", (Object)this.httpRequest.getRequestLine(), (Object)this.peerAddress);
        String oldThreadName = Thread.currentThread().getName();
        Thread.currentThread().setName("PROXY-" + this.httpRequest.getRequestLine().toString());
        sinkChannel.getCloseSetter().set(c -> {
            long latency = System.nanoTime() - this.startNanos;
            MDC.put((String)"request-latency-ns", (String)String.valueOf(latency));
            RequestContextHelper.setContext((String)"http-method", (String)this.httpRequest.getRequestLine().getMethod());
            this.sliMetricSet.function("content.generic").ifPresent(ms -> {
                ms.latency(latency).call();
                if (Integer.parseInt(RequestContextHelper.getContext((String)"http-status", (String)"200")) > 499) {
                    ms.error();
                }
            });
            MDC.put((String)"request-phase", (String)"end");
            this.restLogger.info("END {} (from: {})", (Object)this.httpRequest.getRequestLine(), (Object)this.peerAddress);
            MDC.remove((String)"request-phase");
            this.logger.trace("Sink channel closing.");
            Thread.currentThread().setName(oldThreadName);
            if (this.sslTunnel != null) {
                this.logger.trace("Close ssl tunnel");
                this.sslTunnel.close();
            }
        });
        this.logger.debug("\n\n\n>>>>>>> Handle write\n\n\n");
        if (this.error == null) {
            try {
                if (this.repoCreator == null) {
                    throw new IndyDataException("No valid instance of ProxyRepositoryCreator", new Object[0]);
                }
                UserPass proxyUserPass = UserPass.parse((ApplicationHeader)ApplicationHeader.proxy_authorization, (HttpRequest)this.httpRequest, null);
                this.mdcManager.putExtraHeaders(this.httpRequest);
                if (proxyUserPass != null) {
                    this.mdcManager.putExternalID(proxyUserPass.getUser());
                }
                this.logger.debug("Proxy UserPass: {}\nConfig secured? {}\nConfig tracking type: {}", new Object[]{proxyUserPass, this.config.isSecured(), this.config.getTrackingType()});
                if (proxyUserPass == null && (this.config.isSecured() || TrackingType.ALWAYS == this.config.getTrackingType())) {
                    String realmInfo = String.format("Basic realm=\"%s\"", this.config.getProxyRealm());
                    this.logger.info("Not authenticated to proxy. Sending response: {} / {}: {}", new Object[]{ApplicationStatus.PROXY_AUTHENTICATION_REQUIRED, ApplicationHeader.proxy_authenticate, realmInfo});
                    http.writeStatus(ApplicationStatus.PROXY_AUTHENTICATION_REQUIRED);
                    http.writeHeader(ApplicationHeader.proxy_authenticate, realmInfo);
                } else {
                    RequestLine requestLine = this.httpRequest.getRequestLine();
                    String method = requestLine.getMethod().toUpperCase();
                    String trackingId = null;
                    boolean authenticated = true;
                    ProxyResponseHelper proxyResponseHelper = new ProxyResponseHelper(this.httpRequest, this.config, this.contentController, this.repoCreator, this.storeManager, this.metricsConfig, this.metricRegistry, this.cls);
                    if (proxyUserPass != null) {
                        String authCacheKey;
                        Boolean isAuthToken;
                        TrackingKey trackingKey = proxyResponseHelper.getTrackingKey(proxyUserPass);
                        if (trackingKey != null) {
                            trackingId = trackingKey.getId();
                            MDC.put((String)"tracking-id", (String)trackingId);
                        }
                        if (Boolean.TRUE.equals(isAuthToken = (Boolean)this.proxyAuthCache.get((Object)(authCacheKey = this.generateAuthCacheKey(proxyUserPass))))) {
                            authenticated = true;
                            this.logger.debug("Found auth key in cache");
                        } else {
                            this.logger.debug("Passing BASIC authentication credentials to Keycloak bearer-token translation authenticator");
                            authenticated = this.proxyAuthenticator.authenticate(proxyUserPass, http);
                            if (authenticated) {
                                this.proxyAuthCache.put((Object)authCacheKey, (Object)Boolean.TRUE, this.config.getAuthCacheExpirationHours().intValue(), TimeUnit.HOURS);
                            }
                        }
                        this.logger.debug("Authentication done, result: {}", (Object)authenticated);
                    }
                    if (authenticated) {
                        switch (method) {
                            case "GET": 
                            case "HEAD": {
                                URL url = new URL(requestLine.getUri());
                                this.logger.debug("getArtifactStore starts, trackingId: {}, url: {}", (Object)trackingId, (Object)url);
                                ArtifactStore store = proxyResponseHelper.getArtifactStore(trackingId, url);
                                proxyResponseHelper.transfer(http, store, url.getPath(), "GET".equals(method), proxyUserPass);
                                break;
                            }
                            case "OPTIONS": {
                                http.writeStatus(ApplicationStatus.OK);
                                http.writeHeader(ApplicationHeader.allow, HttpProxyConstants.ALLOW_HEADER_VALUE);
                                break;
                            }
                            case "CONNECT": {
                                if (!this.config.isMITMEnabled()) {
                                    this.logger.debug("CONNECT method not supported unless MITM-proxying is enabled.");
                                    http.writeStatus(ApplicationStatus.BAD_REQUEST);
                                    break;
                                }
                                String uri = requestLine.getUri();
                                this.logger.debug("Get CONNECT request, uri: {}", (Object)uri);
                                String[] toks = uri.split(":");
                                String host = toks[0];
                                int port = Integer.parseInt(toks[1]);
                                this.directed = true;
                                ProxyMITMSSLServer svr = new ProxyMITMSSLServer(host, port, trackingId, proxyUserPass, proxyResponseHelper, this.contentController, this.cacheProvider, this.config);
                                this.tunnelAndMITMExecutor.submit(svr);
                                SocketChannel socketChannel = svr.getSocketChannel();
                                if (socketChannel == null) {
                                    this.logger.debug("Failed to get MITM socket channel");
                                    http.writeStatus(ApplicationStatus.SERVER_ERROR);
                                    svr.stop();
                                    break;
                                }
                                this.sslTunnel = new ProxySSLTunnel(sinkChannel, socketChannel, this.config);
                                this.tunnelAndMITMExecutor.submit(this.sslTunnel);
                                this.proxyRequestReader.setProxySSLTunnel(this.sslTunnel);
                                http.writeStatus(ApplicationStatus.OK);
                                http.writeHeader("Status", "200 OK\n");
                                break;
                            }
                            default: {
                                http.writeStatus(ApplicationStatus.METHOD_NOT_ALLOWED);
                            }
                        }
                    }
                }
                this.logger.debug("Response complete.");
            }
            catch (Throwable e) {
                this.error = e;
            }
            finally {
                this.mdcManager.clear();
            }
        }
        if (this.error != null) {
            this.handleError(this.error, http);
        }
        try {
            if (!this.directed) {
                http.close();
            }
        }
        catch (IOException e) {
            this.logger.error("Failed to shutdown response", (Throwable)e);
        }
    }

    private String generateAuthCacheKey(UserPass proxyUserPass) {
        return DigestUtils.sha256Hex((String)(proxyUserPass.getUser() + ":" + proxyUserPass.getPassword()));
    }

    private void handleError(Throwable error, HttpWrapper http) {
        this.logger.error("HTTProx request failed: " + error.getMessage(), error);
        try {
            if (http.isOpen()) {
                if (error instanceof IndyWorkflowException) {
                    http.writeStatus(ApplicationStatus.getStatus((int)((IndyWorkflowException)error).getStatus()));
                } else {
                    http.writeStatus(ApplicationStatus.SERVER_ERROR);
                }
                http.writeError(error);
                this.logger.debug("Response error complete.");
            }
        }
        catch (IOException closeException) {
            this.logger.error("Failed to close httprox request: " + error.getMessage(), error);
        }
    }

    public void setError(Throwable error) {
        this.error = error;
    }

    public void setHttpRequest(HttpRequest request) {
        this.httpRequest = request;
    }
}

