/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.httprox.handler;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Hex;
import org.apache.http.ConnectionClosedException;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestFactory;
import org.apache.http.config.MessageConstraints;
import org.apache.http.impl.DefaultHttpRequestFactory;
import org.apache.http.impl.io.DefaultHttpRequestParser;
import org.apache.http.impl.io.HttpTransportMetricsImpl;
import org.apache.http.impl.io.SessionInputBufferImpl;
import org.apache.http.io.SessionInputBuffer;
import org.apache.http.message.BasicLineParser;
import org.apache.http.message.LineParser;
import org.commonjava.indy.httprox.handler.ProxyResponseWriter;
import org.commonjava.indy.httprox.handler.ProxySSLTunnel;
import org.commonjava.indy.util.ApplicationHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.ChannelListener;
import org.xnio.conduits.ConduitStreamSinkChannel;
import org.xnio.conduits.ConduitStreamSourceChannel;

public final class ProxyRequestReader
implements ChannelListener<ConduitStreamSourceChannel> {
    private static final int AWAIT_READABLE_IN_MILLISECONDS = 100;
    private static final List<Character> HEAD_END = Collections.unmodifiableList(Arrays.asList(Character.valueOf('\r'), Character.valueOf('\n'), Character.valueOf('\r'), Character.valueOf('\n')));
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ByteArrayOutputStream bReq;
    private PrintStream pReq;
    private boolean headDone = false;
    private final ProxyResponseWriter writer;
    private final ConduitStreamSinkChannel sinkChannel;
    private ProxySSLTunnel sslTunnel;
    private List<Character> lastFour = new ArrayList<Character>();

    public ProxyRequestReader(ProxyResponseWriter writer, ConduitStreamSinkChannel sinkChannel) {
        this.writer = writer;
        this.sinkChannel = sinkChannel;
    }

    public void handleEvent(ConduitStreamSourceChannel sourceChannel) {
        boolean sendResponse = false;
        try {
            int read = this.doRead(sourceChannel);
            if (read <= 0) {
                this.logger.debug("Reads: {} ", (Object)read);
                return;
            }
            byte[] bytes = this.bReq.toByteArray();
            if (this.sslTunnel != null) {
                this.logger.debug("Send to ssl tunnel, {}, bytes:\n\n {}\n", (Object)new String(bytes), (Object)Hex.encodeHexString((byte[])bytes));
                this.directTo(this.sslTunnel);
                return;
            }
            this.logger.debug("Request in progress is:\n\n{}", (Object)new String(bytes));
            if (this.headDone) {
                this.logger.debug("Request done. parsing.");
                MessageConstraints mc = MessageConstraints.DEFAULT;
                SessionInputBufferImpl inbuf = new SessionInputBufferImpl(new HttpTransportMetricsImpl(), 1024);
                DefaultHttpRequestFactory requestFactory = new DefaultHttpRequestFactory();
                BasicLineParser lp = new BasicLineParser();
                DefaultHttpRequestParser requestParser = new DefaultHttpRequestParser((SessionInputBuffer)inbuf, (LineParser)lp, (HttpRequestFactory)requestFactory, mc);
                inbuf.bind((InputStream)new ByteArrayInputStream(bytes));
                try {
                    this.logger.debug("Passing parsed http request off to response writer.");
                    HttpRequest request = (HttpRequest)requestParser.parse();
                    this.logger.debug("Request contains {} header: '{}'", (Object)ApplicationHeader.authorization.key(), (Object)request.getHeaders(ApplicationHeader.authorization.key()));
                    this.writer.setHttpRequest(request);
                    sendResponse = true;
                }
                catch (ConnectionClosedException e) {
                    this.logger.warn("Client closed connection. Aborting proxy request.");
                    sendResponse = false;
                    sourceChannel.shutdownReads();
                }
                catch (HttpException e) {
                    this.logger.error("Failed to parse http request: " + e.getMessage(), (Throwable)e);
                    this.writer.setError(e);
                }
            } else {
                this.logger.debug("Request not finished. Pausing until more reads are available.");
                sourceChannel.resumeReads();
            }
        }
        catch (IOException e) {
            this.writer.setError(e);
            sendResponse = true;
        }
        if (sendResponse) {
            this.sinkChannel.resumeWrites();
        }
    }

    public void setProxySSLTunnel(ProxySSLTunnel sslTunnel) {
        this.sslTunnel = sslTunnel;
    }

    private void directTo(ProxySSLTunnel sslTunnel) throws IOException {
        byte[] bytes = this.bReq.toByteArray();
        this.logger.trace("Write client data to ssl tunnel, size: {}", (Object)bytes.length);
        sslTunnel.write(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doRead(ConduitStreamSourceChannel channel) throws IOException {
        this.bReq = new ByteArrayOutputStream();
        this.pReq = new PrintStream(this.bReq);
        this.logger.debug("Starting read: {}", (Object)channel);
        int total = 0;
        block6: while (true) {
            ByteBuffer buf = ByteBuffer.allocate(1024);
            channel.awaitReadable(100L, TimeUnit.MILLISECONDS);
            int read = channel.read(buf);
            this.logger.debug("Read {} bytes", (Object)read);
            if (read == -1) {
                if (total == 0) {
                    return -1;
                }
                return total;
            }
            if (read == 0) {
                return total;
            }
            total += read;
            buf.flip();
            byte[] bbuf = new byte[buf.limit()];
            buf.get(bbuf);
            if (!this.headDone) {
                String part = new String(bbuf);
                char[] cArray = part.toCharArray();
                int n = cArray.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) continue block6;
                    char c = cArray[n2];
                    switch (c) {
                        case '\n': {
                            while (this.lastFour.size() > 3) {
                                this.lastFour.remove(0);
                            }
                            this.lastFour.add(Character.valueOf(c));
                            try {
                                if (this.bReq.size() <= 0 || !HEAD_END.equals(this.lastFour)) break;
                                this.logger.debug("Detected end of request headers.");
                                this.headDone = true;
                                this.logger.trace("Proxy request header:\n{}\n", (Object)new String(this.bReq.toByteArray()));
                                break;
                            }
                            finally {
                                this.lastFour.remove(this.lastFour.size() - 1);
                            }
                        }
                    }
                    this.pReq.print(c);
                    this.lastFour.add(Character.valueOf(c));
                    ++n2;
                }
            }
            this.bReq.write(bbuf);
        }
    }
}

