/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.httprox.handler;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.nio.channels.SocketChannel;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import org.commonjava.indy.core.ctl.ContentController;
import org.commonjava.indy.httprox.conf.HttproxConfig;
import org.commonjava.indy.httprox.util.CertUtils;
import org.commonjava.indy.httprox.util.CertificateAndKeys;
import org.commonjava.indy.httprox.util.HttpConduitWrapper;
import org.commonjava.indy.httprox.util.OutputStreamSinkChannel;
import org.commonjava.indy.httprox.util.ProxyResponseHelper;
import org.commonjava.indy.model.core.ArtifactStore;
import org.commonjava.indy.subsys.http.util.UserPass;
import org.commonjava.maven.galley.spi.cache.CacheProvider;
import org.commonjava.propulsor.boot.PortFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyMITMSSLServer
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final int FIND_OPEN_PORT_MAX_RETRIES = 16;
    private static final int GET_SOCKET_CHANNEL_MAX_RETRIES = 32;
    private static final int GET_SOCKET_CHANNEL_WAIT_TIME_IN_MILLISECONDS = 500;
    private final String host;
    private final int port;
    private final HttproxConfig config;
    private volatile int serverPort;
    private final String trackingId;
    private final UserPass proxyUserPass;
    private final ContentController contentController;
    private final CacheProvider cacheProvider;
    private final ProxyResponseHelper proxyResponseHelper;
    private volatile boolean started;
    private volatile ServerSocket sslServerSocket;
    private volatile Socket socket;
    private char[] keystorePassword = "password".toCharArray();
    private static Map<String, KeyStore> keystoreMap = new ConcurrentHashMap<String, KeyStore>();

    public ProxyMITMSSLServer(String host, int port, String trackingId, UserPass proxyUserPass, ProxyResponseHelper proxyResponseHelper, ContentController contentController, CacheProvider cacheProvider, HttproxConfig config) {
        this.host = host;
        this.port = port;
        this.trackingId = trackingId;
        this.proxyUserPass = proxyUserPass;
        this.proxyResponseHelper = proxyResponseHelper;
        this.contentController = contentController;
        this.cacheProvider = cacheProvider;
        this.config = config;
    }

    @Override
    public void run() {
        try {
            this.execute();
        }
        catch (Exception e) {
            this.logger.warn("Exception failed", (Throwable)e);
        }
    }

    private SSLServerSocketFactory getSSLServerSocketFactory(String host) throws Exception {
        AtomicReference err = new AtomicReference();
        KeyStore ks = keystoreMap.computeIfAbsent(host, k -> {
            try {
                return this.getKeyStore((String)k);
            }
            catch (Exception e) {
                err.set(e);
                return null;
            }
        });
        if (ks == null || err.get() != null) {
            throw (Exception)err.get();
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(ks, this.keystorePassword);
        SSLContext sc = SSLContext.getInstance("TLS");
        sc.init(kmf.getKeyManagers(), null, null);
        return sc.getServerSocketFactory();
    }

    private KeyStore getKeyStore(String host) throws Exception {
        PrivateKey caKey = CertUtils.getPrivateKey(this.config.getMITMCAKey());
        X509Certificate caCert = CertUtils.loadX509Certificate(new File(this.config.getMITMCACert()));
        String dn = this.config.getMITMDNTemplate().replace("<host>", host);
        CertificateAndKeys certificateAndKeys = CertUtils.createSignedCertificateAndKey(dn, caCert, caKey, false);
        Certificate signedCertificate = certificateAndKeys.getCertificate();
        this.logger.debug("Create signed cert:\n" + signedCertificate.toString());
        KeyStore ks = CertUtils.createKeyStore();
        String alias = host;
        ks.setKeyEntry(alias, certificateAndKeys.getPrivateKey(), this.keystorePassword, new Certificate[]{signedCertificate, caCert});
        return ks;
    }

    private void execute() throws Exception {
        String line;
        SSLServerSocketFactory sslServerSocketFactory = this.getSSLServerSocketFactory(this.host);
        this.serverPort = PortFinder.findOpenPort((int)16);
        this.sslServerSocket = sslServerSocketFactory.createServerSocket(this.serverPort);
        this.logger.debug("MITM server started, {}", (Object)this.sslServerSocket);
        this.started = true;
        this.socket = this.sslServerSocket.accept();
        this.socket.setSoTimeout((int)TimeUnit.MINUTES.toMillis(this.config.getMITMSoTimeoutMinutes().intValue()));
        this.logger.debug("MITM server accepted");
        BufferedReader in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
        String path = null;
        StringBuilder sb = new StringBuilder();
        String method = null;
        while ((line = in.readLine()) != null) {
            sb.append(line + "\n");
            if (line.startsWith("GET") || line.startsWith("HEAD")) {
                String[] toks = line.split("\\s+");
                method = toks[0];
                path = toks[1];
                continue;
            }
            if (!line.isEmpty()) continue;
            this.logger.debug("Get empty line and break");
            break;
        }
        this.logger.debug("Request:\n{}", (Object)sb.toString());
        if (path != null) {
            try {
                this.transferRemote(this.socket, this.host, this.port, method, path);
            }
            catch (Exception e) {
                this.logger.error("Transfer remote failed", (Throwable)e);
            }
        } else {
            this.logger.debug("MITM server failed to get request from client");
        }
        in.close();
        this.socket.close();
        this.sslServerSocket.close();
        this.logger.debug("MITM server closed");
    }

    private void transferRemote(Socket socket, String host, int port, String method, String path) throws Exception {
        String protocol = "https";
        String auth = null;
        String query = null;
        String fragment = null;
        URI uri = new URI(protocol, auth, host, port, path, query, fragment);
        URL remoteUrl = uri.toURL();
        this.logger.debug("Requesting remote URL: {}", (Object)remoteUrl.toString());
        ArtifactStore store = this.proxyResponseHelper.getArtifactStore(this.trackingId, remoteUrl);
        try (OutputStream out = socket.getOutputStream();){
            HttpConduitWrapper http = new HttpConduitWrapper(new OutputStreamSinkChannel(out), null, this.contentController, this.cacheProvider);
            this.proxyResponseHelper.transfer(http, store, remoteUrl.getPath(), "GET".equals(method), this.proxyUserPass);
            http.close();
        }
    }

    public SocketChannel getSocketChannel() throws InterruptedException, ExecutionException {
        for (int i = 0; i < 32; ++i) {
            this.logger.debug("Try to get socket channel #{}", (Object)(i + 1));
            if (this.started) {
                this.logger.debug("Server started");
                try {
                    return this.openSocketChannelToMITM();
                }
                catch (IOException e) {
                    throw new ExecutionException("Open socket channel to MITM failed", e);
                }
            }
            this.logger.debug("Server not started, wait...");
            TimeUnit.MILLISECONDS.sleep(500L);
        }
        return null;
    }

    private SocketChannel openSocketChannelToMITM() throws IOException {
        this.logger.debug("Open socket channel to MITM server, localhost:{}", (Object)this.serverPort);
        InetSocketAddress target = new InetSocketAddress("localhost", this.serverPort);
        return SocketChannel.open(target);
    }

    public void stop() {
        try {
            if (!this.sslServerSocket.isClosed()) {
                this.sslServerSocket.close();
            }
            if (this.socket != null && !this.socket.isClosed()) {
                this.socket.close();
            }
        }
        catch (IOException e) {
            this.logger.debug("Close MITM server, {}", (Object)e.toString());
        }
    }
}

