/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.httprox.handler;

import com.codahale.metrics.MetricRegistry;
import java.io.IOException;
import javax.inject.Inject;
import org.commonjava.indy.bind.jaxrs.MDCManager;
import org.commonjava.indy.bind.jaxrs.RequestContextHelper;
import org.commonjava.indy.core.ctl.ContentController;
import org.commonjava.indy.data.StoreDataManager;
import org.commonjava.indy.httprox.conf.HttproxConfig;
import org.commonjava.indy.httprox.handler.ProxyRepositoryCreator;
import org.commonjava.indy.httprox.handler.ProxyRequestReader;
import org.commonjava.indy.httprox.handler.ProxyResponseWriter;
import org.commonjava.indy.httprox.keycloak.KeycloakProxyAuthenticator;
import org.commonjava.indy.metrics.conf.IndyMetricsConfig;
import org.commonjava.indy.model.core.AccessChannel;
import org.commonjava.indy.sli.metrics.GoldenSignalsMetricSet;
import org.commonjava.indy.subsys.infinispan.CacheProducer;
import org.commonjava.indy.subsys.template.IndyGroovyException;
import org.commonjava.indy.subsys.template.ScriptEngine;
import org.commonjava.maven.galley.spi.cache.CacheProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.xnio.ChannelListener;
import org.xnio.StreamConnection;
import org.xnio.channels.AcceptingChannel;
import org.xnio.conduits.ConduitStreamSinkChannel;
import org.xnio.conduits.ConduitStreamSourceChannel;

public class ProxyAcceptHandler
implements ChannelListener<AcceptingChannel<StreamConnection>> {
    private static final String HTTPROX_REPO_CREATOR_SCRIPT = "httprox-repo-creator.groovy";
    public static final String HTTPROX_ORIGIN = "httprox";
    @Inject
    private HttproxConfig config;
    @Inject
    private StoreDataManager storeManager;
    @Inject
    private ContentController contentController;
    @Inject
    private KeycloakProxyAuthenticator proxyAuthenticator;
    @Inject
    private CacheProvider cacheProvider;
    @Inject
    private ScriptEngine scriptEngine;
    @Inject
    private MDCManager mdcManager;
    @Inject
    MetricRegistry metricRegistry;
    @Inject
    private IndyMetricsConfig metricsConfig;
    @Inject
    private CacheProducer cacheProducer;
    @Inject
    private GoldenSignalsMetricSet sliMetricSet;

    protected ProxyAcceptHandler() {
    }

    public ProxyAcceptHandler(HttproxConfig config, StoreDataManager storeManager, ContentController contentController, KeycloakProxyAuthenticator proxyAuthenticator, CacheProvider cacheProvider, ScriptEngine scriptEngine, MDCManager mdcManager, IndyMetricsConfig metricsConfig, MetricRegistry metricRegistry, CacheProducer cacheProducer) {
        this.config = config;
        this.storeManager = storeManager;
        this.contentController = contentController;
        this.proxyAuthenticator = proxyAuthenticator;
        this.cacheProvider = cacheProvider;
        this.scriptEngine = scriptEngine;
        this.mdcManager = mdcManager;
        this.metricsConfig = metricsConfig;
        this.metricRegistry = metricRegistry;
        this.cacheProducer = cacheProducer;
    }

    public ProxyRepositoryCreator createRepoCreator() {
        ProxyRepositoryCreator creator = null;
        try {
            creator = (ProxyRepositoryCreator)this.scriptEngine.parseStandardScriptInstance(ScriptEngine.StandardScriptType.store_creators, HTTPROX_REPO_CREATOR_SCRIPT, ProxyRepositoryCreator.class);
        }
        catch (IndyGroovyException e) {
            Logger logger = LoggerFactory.getLogger(this.getClass());
            logger.error(String.format("Cannot create ProxyRepositoryCreator instance: %s. Disabling httprox support.", e.getMessage()), (Throwable)e);
            this.config.setEnabled(false);
        }
        return creator;
    }

    public void handleEvent(AcceptingChannel<StreamConnection> channel) {
        StreamConnection accepted;
        long start = System.nanoTime();
        MDC.put((String)"access-channel", (String)AccessChannel.GENERIC_PROXY.toString());
        RequestContextHelper.setContext((String)"package-type", (String)AccessChannel.GENERIC_PROXY.packageType());
        Logger logger = LoggerFactory.getLogger(this.getClass());
        try {
            accepted = (StreamConnection)channel.accept();
            MDC.put((String)"request-phase", (String)"start");
            LoggerFactory.getLogger((String)"org.commonjava.topic.httprox.inbound").info("START HTTProx request (from: {})", (Object)accepted.getPeerAddress());
            MDC.remove((String)"request-phase");
        }
        catch (IOException e) {
            logger.error("Failed to addMetadata httprox connection: " + e.getMessage(), (Throwable)e);
            return;
        }
        if (accepted == null) {
            return;
        }
        logger.debug("accepted {}", (Object)accepted.getPeerAddress());
        ConduitStreamSourceChannel source = accepted.getSourceChannel();
        ConduitStreamSinkChannel sink = accepted.getSinkChannel();
        ProxyRepositoryCreator creator = this.createRepoCreator();
        ProxyResponseWriter writer = new ProxyResponseWriter(this.config, this.storeManager, this.contentController, this.proxyAuthenticator, this.cacheProvider, this.mdcManager, creator, accepted, this.metricsConfig, this.metricRegistry, this.sliMetricSet, this.cacheProducer, start);
        logger.debug("Setting writer: {}", (Object)writer);
        sink.getWriteSetter().set((ChannelListener)writer);
        ProxyRequestReader reader = new ProxyRequestReader(writer, sink);
        writer.setProxyRequestReader(reader);
        logger.debug("Setting reader: {}", (Object)reader);
        source.getReadSetter().set((ChannelListener)reader);
        source.resumeReads();
    }
}

