/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.httprox.handler;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.commonjava.indy.httprox.handler.ProxyCreationResult;
import org.commonjava.indy.httprox.handler.ProxyRepositoryCreator;
import org.commonjava.indy.model.core.ArtifactStore;
import org.commonjava.indy.model.core.Group;
import org.commonjava.indy.model.core.HostedRepository;
import org.commonjava.indy.model.core.PathStyle;
import org.commonjava.indy.model.core.RemoteRepository;
import org.commonjava.indy.model.core.StoreKey;
import org.commonjava.indy.model.core.StoreType;
import org.commonjava.indy.subsys.http.util.UserPass;
import org.commonjava.indy.util.UrlInfo;
import org.slf4j.Logger;

public abstract class AbstractProxyRepositoryCreator
implements ProxyRepositoryCreator {
    @Override
    public abstract ProxyCreationResult create(String var1, String var2, String var3, UrlInfo var4, UserPass var5, Logger var6);

    @Override
    public String formatId(String host, int port, int index, String trackingID, StoreType storeType) {
        host = host.replaceAll("\\.", "-");
        if (trackingID == null) {
            return "httprox_" + host + "_" + port + (index > 0 ? "_" + index : "");
        }
        String prefix = null;
        switch (storeType) {
            case group: {
                prefix = "g";
                break;
            }
            case remote: {
                prefix = "r";
                break;
            }
            case hosted: {
                prefix = "h";
                break;
            }
        }
        return prefix + "-" + host + "-" + trackingID;
    }

    protected RemoteRepository createRemote(String name, String baseUrl, UrlInfo info, UserPass up, Logger logger) {
        return this.createRemote(null, name, baseUrl, info, up, logger);
    }

    protected RemoteRepository createRemote(String trackingID, String name, String baseUrl, UrlInfo info, UserPass up, Logger logger) {
        RemoteRepository remote = new RemoteRepository("generic-http", name, baseUrl);
        if (up != null) {
            remote.setUser(up.getUser());
            remote.setPassword(up.getPassword());
        }
        if (trackingID == null) {
            remote.setPassthrough(true);
        }
        remote.setTimeoutSeconds(300);
        remote.setIgnoreHostnameVerification(true);
        this.setPropsAndMetadata((ArtifactStore)remote, trackingID, info);
        return remote;
    }

    protected HostedRepository createHosted(String trackingID, String name, UrlInfo info, Logger logger) {
        HostedRepository hosted = new HostedRepository("generic-http", name);
        this.setPropsAndMetadata((ArtifactStore)hosted, trackingID, info);
        return hosted;
    }

    protected Group createGroup(String trackingID, String name, UrlInfo info, Logger logger, StoreKey ... constituents) {
        Group group = new Group("generic-http", name, constituents);
        this.setPropsAndMetadata((ArtifactStore)group, trackingID, info);
        return group;
    }

    private void setPropsAndMetadata(ArtifactStore store, String trackingID, UrlInfo info) {
        store.setDescription("HTTProx proxy based on: " + info.getUrl());
        store.setPathStyle(PathStyle.hashed);
        store.setMetadata("origin", "httprox");
        if (trackingID != null) {
            store.setMetadata("trackingId", trackingID);
        }
    }

    public Predicate<ArtifactStore> getNameFilter(String name) {
        return store -> store.getName().startsWith(name);
    }

    public String getNextName(List<String> names) {
        if (names.isEmpty()) {
            return null;
        }
        String name0 = names.get(0);
        if (names.size() == 1) {
            return name0 + "_1";
        }
        Collections.sort(names);
        String last = names.get(names.size() - 1);
        String index = last.substring(last.lastIndexOf("_") + 1);
        return name0 + "_" + (Integer.parseInt(index) + 1);
    }
}

