/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.httprox.data;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.commonjava.indy.content.SpecialPathSetProducer;
import org.commonjava.indy.httprox.conf.HttproxConfig;
import org.commonjava.maven.galley.io.SpecialPathSet;
import org.commonjava.maven.galley.model.FilePatternMatcher;
import org.commonjava.maven.galley.model.SpecialPathInfo;
import org.commonjava.maven.galley.model.SpecialPathMatcher;

@ApplicationScoped
@Named
public class HttProxRegisterSpecialPathStartupAction
implements SpecialPathSetProducer {
    @Inject
    private HttproxConfig config;

    public SpecialPathSet getSpecialPathSet() {
        return new HttpProxSpecialPathSet(this.config);
    }

    private static final class HttpProxSpecialPathSet
    implements SpecialPathSet {
        final List<SpecialPathInfo> notCachableSpecialPaths = new ArrayList<SpecialPathInfo>();

        HttpProxSpecialPathSet(HttproxConfig config) {
            String s = config.getNoCachePatterns();
            if (StringUtils.isNotBlank((String)s)) {
                for (String pattern : s.split(",")) {
                    String trimmed = pattern.trim();
                    if (!StringUtils.isNotBlank((String)trimmed)) continue;
                    this.notCachableSpecialPaths.add(SpecialPathInfo.from((SpecialPathMatcher)new FilePatternMatcher(trimmed)).setCachable(false).build());
                }
            }
        }

        public List<SpecialPathInfo> getSpecialPathInfos() {
            return this.notCachableSpecialPaths;
        }

        public void registerSpecialPathInfo(SpecialPathInfo pathInfo) {
            throw new UnsupportedOperationException();
        }

        public void deregisterSpecialPathInfo(SpecialPathInfo pathInfo) {
            throw new UnsupportedOperationException();
        }

        public String getPackageType() {
            return "generic-http";
        }
    }
}

