/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.httprox.data;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.commonjava.indy.action.IndyLifecycleException;
import org.commonjava.indy.action.MigrationAction;
import org.commonjava.indy.audit.ChangeSummary;
import org.commonjava.indy.data.IndyDataException;
import org.commonjava.indy.data.StoreDataManager;
import org.commonjava.indy.model.core.ArtifactStore;
import org.commonjava.indy.model.core.RemoteRepository;
import org.commonjava.maven.galley.event.EventMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttProxOriginMigrationAction
implements MigrationAction {
    @Inject
    private StoreDataManager storeDataManager;

    public boolean migrate() throws IndyLifecycleException {
        Logger logger = LoggerFactory.getLogger(this.getClass());
        logger.debug("Disabled.");
        return true;
    }

    private boolean doMigrate() throws IndyLifecycleException {
        List repos;
        try {
            repos = this.storeDataManager.query().noPackageType().getAllRemoteRepositories();
        }
        catch (IndyDataException e) {
            throw new IndyLifecycleException("Cannot retrieve all remote repositories. Reason: %s", (Throwable)e, new Object[]{e.getMessage()});
        }
        ArrayList toStore = new ArrayList();
        repos.forEach(repo -> {
            if (repo.getDescription() != null && repo.getDescription().contains("HTTProx proxy")) {
                repo.setMetadata("origin", "httprox");
                RemoteRepository store = repo.copyOf("generic-http", repo.getName());
                toStore.add(store);
            }
        });
        ChangeSummary changeSummary = new ChangeSummary("system", "Adding HttProx origin metadata");
        for (RemoteRepository repo2 : toStore) {
            try {
                this.storeDataManager.storeArtifactStore((ArtifactStore)repo2, changeSummary, false, true, new EventMetadata());
            }
            catch (IndyDataException e) {
                throw new IndyLifecycleException("Failed to store %s with HttProx origin metadata. Reason: %s", (Throwable)e, new Object[]{repo2 == null ? "NULL REPO" : repo2.getKey(), e.getMessage()});
            }
        }
        return !toStore.isEmpty();
    }

    public int getMigrationPriority() {
        return 10;
    }

    public String getId() {
        return "HttProx origin metadata migration";
    }
}

