/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.httprox.conf;

import java.io.File;
import java.io.InputStream;
import javax.enterprise.context.ApplicationScoped;
import org.commonjava.indy.conf.IndyConfigInfo;
import org.commonjava.indy.httprox.conf.TrackingType;
import org.commonjava.propulsor.config.annotation.ConfigName;
import org.commonjava.propulsor.config.annotation.SectionName;

@SectionName(value="httprox")
@ApplicationScoped
public class HttproxConfig
implements IndyConfigInfo {
    private static final int DEFAULT_PORT = 8081;
    private static final boolean DEFAULT_ENABLED = false;
    private static final String DEFAULT_PROXY_REALM = "httprox";
    private static final boolean DEFAULT_SECURED = false;
    private static final boolean DEFAULT_MITM_ENABLED = false;
    private static final String DEFAULT_TRACKING_TYPE = TrackingType.SUFFIX.name();
    private static final int DEFAULT_AUTH_CACHE_EXPIRATION_HOURS = 1;
    private static final int DEFAULT_MITM_SO_TIMEOUT_MINUTES = 30;
    private String proxyRealm;
    private Boolean enabled;
    private Boolean MITMEnabled;
    private Boolean secured;
    private Integer port;
    private Integer authCacheExpirationHours;
    private String trackingType;
    private String noCachePatterns;
    private String MITMCAKey;
    private String MITMCACert;
    private String MITMDNTemplate;
    private Integer MITMSoTimeoutMinutes;

    public TrackingType getTrackingType() {
        return TrackingType.valueOf(this.trackingType == null ? DEFAULT_TRACKING_TYPE : this.trackingType.toUpperCase());
    }

    @ConfigName(value="tracking.type")
    public void setTrackingType(String option) {
        this.trackingType = option;
    }

    public void setTrackingType(TrackingType type) {
        this.trackingType = type.name();
    }

    public boolean isEnabled() {
        return this.enabled == null ? false : this.enabled;
    }

    @ConfigName(value="enabled")
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isSecured() {
        return this.secured == null ? false : this.secured;
    }

    @ConfigName(value="secured")
    public void setSecured(Boolean secured) {
        this.secured = secured;
    }

    public Integer getPort() {
        return this.port == null ? 8081 : this.port;
    }

    @ConfigName(value="port")
    public void setPort(Integer port) {
        this.port = port;
    }

    public String getProxyRealm() {
        return this.proxyRealm == null ? DEFAULT_PROXY_REALM : this.proxyRealm;
    }

    @ConfigName(value="proxy.realm")
    public void setProxyRealm(String proxyRealm) {
        this.proxyRealm = proxyRealm;
    }

    public Integer getAuthCacheExpirationHours() {
        return this.authCacheExpirationHours == null ? 1 : this.authCacheExpirationHours;
    }

    @ConfigName(value="auth.cache.expiration.hours")
    public void setAuthCacheExpirationHours(Integer authCacheExpirationHours) {
        this.authCacheExpirationHours = authCacheExpirationHours;
    }

    public String getDefaultConfigFileName() {
        return new File("conf.d", "httprox.conf").getPath();
    }

    public InputStream getDefaultConfig() {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream("default-httprox.conf");
    }

    public String getNoCachePatterns() {
        return this.noCachePatterns;
    }

    @ConfigName(value="nocache.patterns")
    public void setNoCachePatterns(String noCachePatterns) {
        this.noCachePatterns = noCachePatterns;
    }

    @ConfigName(value="MITM.enabled")
    public void setMITMEnabled(Boolean MITMEnabled) {
        this.MITMEnabled = MITMEnabled;
    }

    public boolean isMITMEnabled() {
        return this.MITMEnabled == null ? false : this.MITMEnabled;
    }

    public String getMITMCAKey() {
        return this.MITMCAKey;
    }

    @ConfigName(value="MITM.ca.key")
    public void setMITMCAKey(String MITMCAKey) {
        this.MITMCAKey = MITMCAKey;
    }

    public String getMITMCACert() {
        return this.MITMCACert;
    }

    @ConfigName(value="MITM.ca.cert")
    public void setMITMCACert(String MITMCACert) {
        this.MITMCACert = MITMCACert;
    }

    public String getMITMDNTemplate() {
        return this.MITMDNTemplate;
    }

    @ConfigName(value="MITM.dn.template")
    public void setMITMDNTemplate(String MITMDNTemplate) {
        this.MITMDNTemplate = MITMDNTemplate;
    }

    public Integer getMITMSoTimeoutMinutes() {
        return this.MITMSoTimeoutMinutes == null ? 30 : this.MITMSoTimeoutMinutes;
    }

    @ConfigName(value="MITM.so.timeout.minutes")
    public void setMITMSoTimeoutMinutes(Integer MITMSoTimeoutMinutes) {
        this.MITMSoTimeoutMinutes = MITMSoTimeoutMinutes;
    }
}

