/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.httprox;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.commonjava.indy.action.IndyLifecycleException;
import org.commonjava.indy.action.ShutdownAction;
import org.commonjava.indy.action.StartupAction;
import org.commonjava.indy.httprox.conf.HttproxConfig;
import org.commonjava.indy.httprox.handler.ProxyAcceptHandler;
import org.commonjava.propulsor.boot.BootOptions;
import org.commonjava.propulsor.boot.PortFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.ChannelListener;
import org.xnio.OptionMap;
import org.xnio.StreamConnection;
import org.xnio.Xnio;
import org.xnio.XnioWorker;
import org.xnio.channels.AcceptingChannel;

@ApplicationScoped
public class HttpProxy
implements StartupAction,
ShutdownAction {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    private HttproxConfig config;
    @Inject
    private BootOptions bootOptions;
    @Inject
    private ProxyAcceptHandler acceptHandler;
    private AcceptingChannel<StreamConnection> server;

    protected HttpProxy() {
    }

    public HttpProxy(HttproxConfig config, BootOptions bootOptions, ProxyAcceptHandler acceptHandler) {
        this.config = config;
        this.bootOptions = bootOptions;
        this.acceptHandler = acceptHandler;
    }

    public void start() throws IndyLifecycleException {
        if (!this.config.isEnabled()) {
            this.logger.info("HTTProx proxy is disabled.");
            return;
        }
        String bind = this.bootOptions.getBind() == null ? "0.0.0.0" : this.bootOptions.getBind();
        this.logger.info("Starting HTTProx proxy on: {}:{}", (Object)bind, (Object)this.config.getPort());
        try {
            InetSocketAddress addr;
            XnioWorker worker = Xnio.getInstance().createWorker(OptionMap.EMPTY);
            if (this.config.getPort() < 1) {
                ThreadLocal using = new ThreadLocal();
                ThreadLocal errorHolder = new ThreadLocal();
                this.server = (AcceptingChannel)PortFinder.findPortFor((int)16, foundPort -> {
                    InetSocketAddress a = new InetSocketAddress(bind, (int)this.config.getPort());
                    AcceptingChannel result = worker.createStreamConnectionServer((SocketAddress)a, (ChannelListener)this.acceptHandler, OptionMap.EMPTY);
                    result.resumeAccepts();
                    using.set(a);
                    return result;
                });
                addr = (InetSocketAddress)using.get();
                this.config.setPort(addr.getPort());
            } else {
                addr = new InetSocketAddress(bind, (int)this.config.getPort());
                this.server = worker.createStreamConnectionServer((SocketAddress)addr, (ChannelListener)this.acceptHandler, OptionMap.EMPTY);
                this.server.resumeAccepts();
            }
            this.logger.info("HTTProxy listening on: {}", (Object)addr);
        }
        catch (IOException | IllegalArgumentException e) {
            throw new IndyLifecycleException("Failed to start HTTProx general content proxy: %s", (Throwable)e, new Object[]{e.getMessage()});
        }
    }

    public void stop() {
        if (this.server != null) {
            try {
                this.logger.info("stopping server");
                this.server.suspendAccepts();
                this.server.close();
            }
            catch (IOException e) {
                this.logger.error("Failed to stop: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public String getId() {
        return "httproxy-listener";
    }

    public int getStartupPriority() {
        return 1;
    }

    public int getShutdownPriority() {
        return 99;
    }
}

