/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.relate.ftest;

import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.commonjava.indy.model.core.ArtifactStore;
import org.commonjava.indy.model.core.Group;
import org.commonjava.indy.model.core.RemoteRepository;
import org.commonjava.indy.model.core.StoreKey;
import org.commonjava.indy.model.core.StoreType;
import org.commonjava.indy.relate.ftest.AbstractRelateFunctionalTest;
import org.commonjava.test.http.expect.ExpectationServer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class PomDownloadViaGroupListenerTest
extends AbstractRelateFunctionalTest {
    private static final String path = "org/foo/bar/1/bar-1.pom";
    private static final String pathRel = "org/foo/bar/1/bar-1.pom.rel";
    private static final String content = "<project><modelVersion>4.0.0</modelVersion><groupId>org.foo</groupId><artifactId>bar</artifactId><version>1</version></project>";
    @Rule
    public ExpectationServer server = new ExpectationServer();

    @Test
    public void run() throws Exception {
        String repo1 = "repo1";
        String group1 = "group1";
        this.server.expect(this.server.formatUrl(new String[]{"repo1", path}), 200, content);
        RemoteRepository remote1 = new RemoteRepository("repo1", this.server.formatUrl(new String[]{"repo1"}));
        this.client.stores().create((ArtifactStore)remote1, "adding remote", RemoteRepository.class);
        this.client.stores().create((ArtifactStore)new Group("group1", new StoreKey[]{remote1.getKey()}), "adding group", Group.class);
        InputStream is = this.client.content().get(StoreType.group, "group1", path);
        String s = IOUtils.toString((InputStream)is);
        Assert.assertThat((Object)s, (Matcher)CoreMatchers.equalTo((Object)content));
        this.waitForEventPropagation();
        boolean exists = this.client.content().exists(StoreType.group, "group1", pathRel, true);
        Assert.assertThat((Object)exists, (Matcher)CoreMatchers.equalTo((Object)true));
        exists = this.client.content().exists(StoreType.remote, "repo1", pathRel, true);
        Assert.assertThat((Object)exists, (Matcher)CoreMatchers.equalTo((Object)true));
        InputStream ris = this.client.content().get(StoreType.group, "group1", pathRel);
        String rel = IOUtils.toString((InputStream)ris);
        this.logger.debug(">>> " + rel);
        Assert.assertThat((Object)StringUtils.isNotEmpty((String)rel), (Matcher)CoreMatchers.equalTo((Object)true));
    }
}

