/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.relate.ftest;

import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.commonjava.indy.model.core.ArtifactStore;
import org.commonjava.indy.model.core.RemoteRepository;
import org.commonjava.indy.model.core.StoreType;
import org.commonjava.indy.relate.ftest.AbstractRelateFunctionalTest;
import org.commonjava.test.http.expect.ExpectationServer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class RelDownloadBeforePomTest
extends AbstractRelateFunctionalTest {
    private static final String path = "org/foo/bar/1/bar-1.pom";
    private static final String pathRel = "org/foo/bar/1/bar-1.pom.rel";
    private static final String content = "<project><modelVersion>4.0.0</modelVersion><groupId>org.foo</groupId><artifactId>bar</artifactId><version>1</version></project>";
    @Rule
    public ExpectationServer server = new ExpectationServer();

    @Test
    public void run() throws Exception {
        String repo1 = "repo1";
        this.server.expect(this.server.formatUrl(new String[]{"repo1", path}), 200, content);
        RemoteRepository remote1 = new RemoteRepository("repo1", this.server.formatUrl(new String[]{"repo1"}));
        this.client.stores().create((ArtifactStore)remote1, "adding remote", RemoteRepository.class);
        InputStream rel = this.client.content().get(StoreType.remote, "repo1", pathRel);
        Assert.assertThat((Object)rel, (Matcher)CoreMatchers.notNullValue());
        String s = IOUtils.toString((InputStream)rel);
        this.logger.debug(">>> " + s);
        Assert.assertThat((Object)StringUtils.isNotEmpty((String)s), (Matcher)CoreMatchers.equalTo((Object)true));
        boolean exists = this.client.content().exists(StoreType.remote, "repo1", path, true);
        Assert.assertThat((Object)exists, (Matcher)CoreMatchers.equalTo((Object)true));
    }
}

