/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.relate.ftest;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.commonjava.atlas.maven.graph.jackson.ProjectRelationshipSerializerModule;
import org.commonjava.atlas.maven.graph.model.EProjectDirectRelationships;
import org.commonjava.atlas.maven.ident.jackson.ProjectVersionRefSerializerModule;
import org.commonjava.indy.model.core.ArtifactStore;
import org.commonjava.indy.model.core.Group;
import org.commonjava.indy.model.core.RemoteRepository;
import org.commonjava.indy.model.core.StoreKey;
import org.commonjava.indy.model.core.StoreType;
import org.commonjava.indy.relate.ftest.AbstractRelateFunctionalTest;
import org.commonjava.test.http.expect.ExpectationServer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class PomDownloadSimpleDepTest
extends AbstractRelateFunctionalTest {
    private static final String resource = "simple-dep";
    private static final String repo = "simple-dep/repo";
    private static final String pathDep = "org/bar/dep/1.1/dep-1.1.pom";
    private static final String pathConsumer = "org/foo/consumer/1/consumer-1.pom";
    private static final String pathConsumerRel = "org/foo/consumer/1/consumer-1.pom.rel";
    private static final String repo1 = "repo1";
    private static final String group1 = "group1";
    @Rule
    public ExpectationServer server = new ExpectationServer();
    ObjectMapper mapper;

    @Before
    public void init() {
        this.mapper = new ObjectMapper();
        this.mapper.registerModules(new Module[]{new ProjectVersionRefSerializerModule(), new ProjectRelationshipSerializerModule()});
    }

    @Test
    public void run() throws Exception {
        String depPom = this.readTestResource("simple-dep/repo/org/bar/dep/1.1/dep-1.1.pom");
        this.server.expect(this.server.formatUrl(new String[]{repo1, pathDep}), 200, depPom);
        String consumerPom = this.readTestResource("simple-dep/repo/org/foo/consumer/1/consumer-1.pom");
        this.server.expect(this.server.formatUrl(new String[]{repo1, pathConsumer}), 200, consumerPom);
        RemoteRepository remote1 = new RemoteRepository(repo1, this.server.formatUrl(new String[]{repo1}));
        this.client.stores().create((ArtifactStore)remote1, "adding remote1", RemoteRepository.class);
        this.client.stores().create((ArtifactStore)new Group(group1, new StoreKey[]{remote1.getKey()}), "adding group", Group.class);
        InputStream is = this.client.content().get(StoreType.group, group1, pathConsumer);
        String s = IOUtils.toString((InputStream)is);
        this.logger.debug(">>> " + s);
        Assert.assertThat((Object)s, (Matcher)CoreMatchers.equalTo((Object)consumerPom));
        this.waitForEventPropagation();
        boolean exists = false;
        exists = this.client.content().exists(StoreType.group, group1, pathConsumer, true);
        Assert.assertThat((Object)exists, (Matcher)CoreMatchers.equalTo((Object)true));
        exists = this.client.content().exists(StoreType.group, group1, pathConsumerRel);
        Assert.assertThat((Object)exists, (Matcher)CoreMatchers.equalTo((Object)true));
        exists = this.client.content().exists(StoreType.remote, repo1, pathConsumerRel, true);
        Assert.assertThat((Object)exists, (Matcher)CoreMatchers.equalTo((Object)true));
        InputStream ris = this.client.content().get(StoreType.group, group1, pathConsumerRel);
        String rel = IOUtils.toString((InputStream)ris);
        this.logger.debug(">>> " + rel);
        Assert.assertThat((Object)StringUtils.isNotEmpty((String)rel), (Matcher)CoreMatchers.equalTo((Object)true));
        String output = this.readTestResource("simple-dep/output/rel.json");
        EProjectDirectRelationships eRel = (EProjectDirectRelationships)this.mapper.readValue(rel, EProjectDirectRelationships.class);
        EProjectDirectRelationships eRelOutput = (EProjectDirectRelationships)this.mapper.readValue(output, EProjectDirectRelationships.class);
        Assert.assertThat((Object)eRel.getDependencies(), (Matcher)CoreMatchers.equalTo((Object)eRelOutput.getDependencies()));
    }
}

