/**
 * Copyright (C) 2011-2018 Red Hat, Inc. (https://github.com/Commonjava/indy)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.commonjava.indy.relate.ftest;

import org.commonjava.indy.ftest.core.AbstractIndyFunctionalTest;
import org.commonjava.indy.test.fixture.core.CoreServerFixture;

import java.io.IOException;

/**
 * Created by jdcasey on 9/27/17.
 */
public abstract class AbstractRelateFunctionalTest
        extends AbstractIndyFunctionalTest
{
    @Override
    protected void initTestConfig( final CoreServerFixture fixture )
            throws IOException
    {
        writeConfigFile( "conf.d/relate.conf", "[relate]\nenabled=true" );
    }
}
