/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.relate.ftest;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.commonjava.indy.model.core.ArtifactStore;
import org.commonjava.indy.model.core.RemoteRepository;
import org.commonjava.indy.model.core.StoreType;
import org.commonjava.indy.relate.ftest.AbstractRelateFunctionalTest;
import org.commonjava.maven.atlas.graph.jackson.ProjectRelationshipSerializerModule;
import org.commonjava.maven.atlas.graph.model.EProjectDirectRelationships;
import org.commonjava.maven.atlas.ident.jackson.ProjectVersionRefSerializerModule;
import org.commonjava.test.http.expect.ExpectationServer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class PomDownloadDepFromParentTest
extends AbstractRelateFunctionalTest {
    private static final String resource = "dep-from-parent";
    private static final String repo = "dep-from-parent/repo";
    private static final String pathDep = "org/bar/dep/1.1/dep-1.1.pom";
    private static final String pathConsumer = "org/foo/consumer/1/consumer-1.pom";
    private static final String pathConsumerParent = "org/foo/parent/1/parent-1.pom";
    private static final String pathConsumerRel = "org/foo/consumer/1/consumer-1.pom.rel";
    private static final String pathConsumerParentRel = "org/foo/parent/1/parent-1.pom.rel";
    private static final String repo1 = "repo1";
    @Rule
    public ExpectationServer server = new ExpectationServer();
    ObjectMapper mapper;

    @Before
    public void init() {
        this.mapper = new ObjectMapper();
        this.mapper.registerModules(new Module[]{new ProjectVersionRefSerializerModule(), new ProjectRelationshipSerializerModule()});
    }

    @Test
    public void run() throws Exception {
        String depPom = this.readTestResource("dep-from-parent/repo/org/bar/dep/1.1/dep-1.1.pom");
        this.server.expect(this.server.formatUrl(new String[]{repo1, pathDep}), 200, depPom);
        String consumerPom = this.readTestResource("dep-from-parent/repo/org/foo/consumer/1/consumer-1.pom");
        this.server.expect(this.server.formatUrl(new String[]{repo1, pathConsumer}), 200, consumerPom);
        String consumerParentPom = this.readTestResource("dep-from-parent/repo/org/foo/parent/1/parent-1.pom");
        this.server.expect(this.server.formatUrl(new String[]{repo1, pathConsumerParent}), 200, consumerParentPom);
        RemoteRepository remote1 = new RemoteRepository(repo1, this.server.formatUrl(new String[]{repo1}));
        this.client.stores().create((ArtifactStore)remote1, "adding remote1", RemoteRepository.class);
        InputStream is = this.client.content().get(StoreType.remote, repo1, pathConsumer);
        Assert.assertThat((Object)is, (Matcher)CoreMatchers.notNullValue());
        String s = IOUtils.toString((InputStream)is);
        this.logger.debug(">>> " + s);
        Assert.assertThat((Object)s, (Matcher)CoreMatchers.equalTo((Object)consumerPom));
        this.waitForEventPropagation();
        boolean exists = false;
        exists = this.client.content().exists(StoreType.remote, repo1, pathConsumerRel, true);
        Assert.assertThat((Object)exists, (Matcher)CoreMatchers.equalTo((Object)true));
        exists = this.client.content().exists(StoreType.remote, repo1, pathConsumerParent, true);
        Assert.assertThat((Object)exists, (Matcher)CoreMatchers.equalTo((Object)true));
        exists = this.client.content().exists(StoreType.remote, repo1, pathConsumerParentRel, true);
        Assert.assertThat((Object)exists, (Matcher)CoreMatchers.equalTo((Object)true));
        InputStream ris = this.client.content().get(StoreType.remote, repo1, pathConsumerRel);
        Assert.assertThat((Object)ris, (Matcher)CoreMatchers.notNullValue());
        String rel = IOUtils.toString((InputStream)ris);
        this.logger.debug(">>> " + rel);
        String output = this.readTestResource("dep-from-parent/output/rel.json");
        EProjectDirectRelationships eRel = (EProjectDirectRelationships)this.mapper.readValue(rel, EProjectDirectRelationships.class);
        EProjectDirectRelationships eRelOutput = (EProjectDirectRelationships)this.mapper.readValue(output, EProjectDirectRelationships.class);
        Assert.assertThat((Object)eRel.getParent(), (Matcher)CoreMatchers.equalTo((Object)eRelOutput.getParent()));
    }
}

