/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.folo.ftest.urls;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.commonjava.indy.client.core.IndyClientHttp;
import org.commonjava.indy.folo.ftest.urls.AbstractFoloUrlsTest;
import org.commonjava.indy.model.core.StoreType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.junit.Test;

public class StoreOneAndSourceStoreUrlInHtmlListingTest
extends AbstractFoloUrlsTest {
    @Test
    public void storeOneFileAndVerifyItInParentDirectoryListing() throws Exception {
        byte[] data = "this is a test".getBytes();
        ByteArrayInputStream stream = new ByteArrayInputStream(data);
        String root = "/path/to/";
        String path = "/path/to/foo.txt";
        String track = "track";
        this.content.store("track", StoreType.hosted, "test", "/path/to/foo.txt", (InputStream)stream);
        IndyClientHttp http = this.getHttp();
        HttpGet request = http.newRawGet(this.content.contentUrl("track", StoreType.hosted, "test", new String[]{"/path/to/"}));
        request.addHeader("Accept", "text/html");
        CloseableHttpClient hc = http.newClient();
        CloseableHttpResponse response = hc.execute((HttpUriRequest)request);
        InputStream listing = response.getEntity().getContent();
        String html = IOUtils.toString((InputStream)listing);
        Document doc = Jsoup.parse((String)html);
        for (Element item : doc.select("a.source-link")) {
            String fname = item.text();
            System.out.printf("Listing contains: '%s'\n", fname);
            String href = item.attr("href");
            String expected = this.client.content().contentUrl(StoreType.hosted, "test", new String[0]);
            MatcherAssert.assertThat((String)(fname + " does not have a href"), (Object)href, (Matcher)CoreMatchers.notNullValue());
            MatcherAssert.assertThat((String)(fname + " has incorrect link: '" + href + "' (" + href.getClass().getName() + ")\nshould be: '" + expected + "' (String)"), (Object)href, (Matcher)CoreMatchers.equalTo((Object)expected));
        }
    }
}

