/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.folo.ftest.report;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Set;
import org.commonjava.indy.folo.client.IndyFoloAdminClientModule;
import org.commonjava.indy.folo.client.IndyFoloContentClientModule;
import org.commonjava.indy.folo.dto.TrackedContentDTO;
import org.commonjava.indy.folo.dto.TrackedContentEntryDTO;
import org.commonjava.indy.folo.ftest.report.AbstractTrackingReportTest;
import org.commonjava.indy.ftest.core.category.EventDependent;
import org.commonjava.indy.model.core.StoreKey;
import org.commonjava.indy.model.core.StoreType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={EventDependent.class})
public class StoreFileAndRecalculateTrackingEntryTest
extends AbstractTrackingReportTest {
    @Test
    public void run() throws Exception {
        String trackingId = this.newName();
        byte[] oldData = ("This is a test: " + System.nanoTime()).getBytes();
        ByteArrayInputStream stream = new ByteArrayInputStream(oldData);
        String path = "/path/to/foo.class";
        ((IndyFoloContentClientModule)this.client.module(IndyFoloContentClientModule.class)).store(trackingId, StoreType.hosted, "test", "/path/to/foo.class", (InputStream)stream);
        IndyFoloAdminClientModule adminModule = (IndyFoloAdminClientModule)this.client.module(IndyFoloAdminClientModule.class);
        boolean success = adminModule.sealTrackingRecord(trackingId);
        MatcherAssert.assertThat((Object)success, (Matcher)CoreMatchers.equalTo((Object)true));
        TrackedContentDTO report = adminModule.getTrackingReport(trackingId);
        MatcherAssert.assertThat((Object)report, (Matcher)CoreMatchers.notNullValue());
        Set uploads = report.getUploads();
        MatcherAssert.assertThat((Object)uploads, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)uploads.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        TrackedContentEntryDTO entry = (TrackedContentEntryDTO)uploads.iterator().next();
        System.out.println(entry);
        MatcherAssert.assertThat((Object)entry, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)entry.getStoreKey(), (Matcher)CoreMatchers.equalTo((Object)new StoreKey(StoreType.hosted, "test")));
        MatcherAssert.assertThat((Object)entry.getPath(), (Matcher)CoreMatchers.equalTo((Object)"/path/to/foo.class"));
        MatcherAssert.assertThat((Object)entry.getLocalUrl(), (Matcher)CoreMatchers.equalTo((Object)this.client.content().contentUrl(StoreType.hosted, "test", new String[]{"/path/to/foo.class"})));
        MatcherAssert.assertThat((Object)entry.getMd5(), (Matcher)CoreMatchers.equalTo((Object)this.md5Hex(oldData)));
        MatcherAssert.assertThat((Object)entry.getOriginUrl(), (Matcher)CoreMatchers.nullValue());
        byte[] newData = ("This is a REPLACED test: " + System.nanoTime()).getBytes();
        stream = new ByteArrayInputStream(newData);
        this.client.content().store(StoreType.hosted, "test", "/path/to/foo.class", (InputStream)stream);
        report = adminModule.recalculateTrackingRecord(trackingId);
        MatcherAssert.assertThat((Object)report, (Matcher)CoreMatchers.notNullValue());
        uploads = report.getUploads();
        MatcherAssert.assertThat((Object)uploads, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)uploads.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        entry = (TrackedContentEntryDTO)uploads.iterator().next();
        System.out.println(entry);
        MatcherAssert.assertThat((Object)entry, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)entry.getStoreKey(), (Matcher)CoreMatchers.equalTo((Object)new StoreKey(StoreType.hosted, "test")));
        MatcherAssert.assertThat((Object)entry.getPath(), (Matcher)CoreMatchers.equalTo((Object)"/path/to/foo.class"));
        MatcherAssert.assertThat((Object)entry.getLocalUrl(), (Matcher)CoreMatchers.equalTo((Object)this.client.content().contentUrl(StoreType.hosted, "test", new String[]{"/path/to/foo.class"})));
        MatcherAssert.assertThat((Object)entry.getMd5(), (Matcher)CoreMatchers.equalTo((Object)this.md5Hex(newData)));
        MatcherAssert.assertThat((Object)entry.getOriginUrl(), (Matcher)CoreMatchers.nullValue());
    }
}

