/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.folo.ftest.report;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.commonjava.indy.folo.client.IndyFoloAdminClientModule;
import org.commonjava.indy.folo.client.IndyFoloContentClientModule;
import org.commonjava.indy.folo.dto.TrackedContentDTO;
import org.commonjava.indy.folo.dto.TrackedContentEntryDTO;
import org.commonjava.indy.folo.ftest.report.AbstractTrackingReportTest;
import org.commonjava.indy.ftest.core.category.EventDependent;
import org.commonjava.indy.model.core.ArtifactStore;
import org.commonjava.indy.model.core.RemoteRepository;
import org.commonjava.indy.model.core.StoreKey;
import org.commonjava.indy.model.core.StoreType;
import org.commonjava.indy.test.fixture.core.CoreServerFixture;
import org.commonjava.test.http.expect.ExpectationServer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Ignore
@Category(value={EventDependent.class})
public class RetrieveTrackingReportAfterCacheExpirationTest
extends AbstractTrackingReportTest {
    @Rule
    public ExpectationServer server = new ExpectationServer();

    protected void initTestConfig(CoreServerFixture fixture) throws IOException {
        this.writeConfigFile("conf.d/folo.conf", "[folo]\ncache.timeout.seconds=1");
    }

    @Test
    public void run() throws Exception {
        String trackingId = this.newName();
        String repoId = "repo";
        String path = "/path/to/foo.class";
        ByteArrayInputStream stream = new ByteArrayInputStream(("This is a test: " + System.nanoTime()).getBytes());
        this.server.expect(this.server.formatUrl(new String[]{"repo", "/path/to/foo.class"}), 200, (InputStream)stream);
        RemoteRepository rr = new RemoteRepository("repo", this.server.formatUrl(new String[]{"repo"}));
        rr = (RemoteRepository)this.client.stores().create((ArtifactStore)rr, "adding test remote", RemoteRepository.class);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InputStream in = ((IndyFoloContentClientModule)this.client.module(IndyFoloContentClientModule.class)).get(trackingId, StoreType.remote, "repo", "/path/to/foo.class");
        IOUtils.copy((InputStream)in, (OutputStream)baos);
        in.close();
        byte[] bytes = baos.toByteArray();
        String md5 = this.md5Hex(bytes);
        String sha256 = this.sha256Hex(bytes);
        MatcherAssert.assertThat((Object)md5, (Matcher)CoreMatchers.equalTo((Object)DigestUtils.md5Hex((byte[])bytes)));
        MatcherAssert.assertThat((Object)sha256, (Matcher)CoreMatchers.equalTo((Object)DigestUtils.sha256Hex((byte[])bytes)));
        Thread.sleep(2000L);
        MatcherAssert.assertThat((Object)((IndyFoloAdminClientModule)this.client.module(IndyFoloAdminClientModule.class)).sealTrackingRecord(trackingId), (Matcher)CoreMatchers.equalTo((Object)true));
        TrackedContentDTO report = ((IndyFoloAdminClientModule)this.client.module(IndyFoloAdminClientModule.class)).getTrackingReport(trackingId);
        MatcherAssert.assertThat((Object)report, (Matcher)CoreMatchers.notNullValue());
        Set downloads = report.getDownloads();
        MatcherAssert.assertThat((Object)downloads, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)downloads.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        TrackedContentEntryDTO entry = (TrackedContentEntryDTO)downloads.iterator().next();
        System.out.println(entry);
        MatcherAssert.assertThat((Object)entry, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)entry.getStoreKey(), (Matcher)CoreMatchers.equalTo((Object)new StoreKey(StoreType.remote, "repo")));
        MatcherAssert.assertThat((Object)entry.getPath(), (Matcher)CoreMatchers.equalTo((Object)"/path/to/foo.class"));
        MatcherAssert.assertThat((Object)entry.getLocalUrl(), (Matcher)CoreMatchers.equalTo((Object)this.client.content().contentUrl(StoreType.remote, "repo", new String[]{"/path/to/foo.class"})));
        MatcherAssert.assertThat((Object)entry.getOriginUrl(), (Matcher)CoreMatchers.equalTo((Object)this.server.formatUrl(new String[]{"repo", "/path/to/foo.class"})));
        MatcherAssert.assertThat((Object)entry.getMd5(), (Matcher)CoreMatchers.equalTo((Object)md5));
        MatcherAssert.assertThat((Object)entry.getSha256(), (Matcher)CoreMatchers.equalTo((Object)sha256));
    }

    @Override
    protected boolean createStandardStores() {
        return false;
    }
}

