/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.folo.ftest.report;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.commonjava.indy.folo.client.IndyFoloAdminClientModule;
import org.commonjava.indy.folo.client.IndyFoloContentClientModule;
import org.commonjava.indy.folo.dto.TrackedContentDTO;
import org.commonjava.indy.folo.dto.TrackedContentEntryDTO;
import org.commonjava.indy.folo.ftest.report.AbstractTrackingReportTest;
import org.commonjava.indy.ftest.core.category.BytemanTest;
import org.commonjava.indy.model.core.ArtifactStore;
import org.commonjava.indy.model.core.RemoteRepository;
import org.commonjava.indy.model.core.StoreKey;
import org.commonjava.indy.model.core.StoreType;
import org.commonjava.test.http.expect.ExpectationServer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jboss.byteman.contrib.bmunit.BMRule;
import org.jboss.byteman.contrib.bmunit.BMRules;
import org.jboss.byteman.contrib.bmunit.BMUnitConfig;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=BMUnitRunner.class)
@BMUnitConfig(debug=true)
@Category(value={BytemanTest.class})
public class RecalculateMissingChecksumForTrackingRecordTest
extends AbstractTrackingReportTest {
    @Rule
    public ExpectationServer server = new ExpectationServer();

    @BMRules(rules={@BMRule(name="setup_metadata_retrieval_countdown", targetClass="^org.commonjava.indy.content.ContentDigester", isInterface=true, targetMethod="<init>", targetLocation="ENTRY", action="System.out.println(\"SETUP COUNTDOWN\"); createCountDown(\"COUNTDOWN\", 1);"), @BMRule(name="prevent_first_metadata_retrieval", targetClass="^org.commonjava.indy.content.ContentDigester", isInterface=true, targetMethod="getContentMetadata", targetLocation="ENTRY", binding="path:String = $1.getPath();", condition="path.endsWith(\"path/to/foo.class\") && !countDown(\"COUNTDOWN\")", action="System.out.println(\"RETURN NULL\"); return null;")})
    @Test
    public void run() throws Exception {
        String trackingId = this.newName();
        String repoId = "repo";
        String path = "/path/to/foo.class";
        ByteArrayInputStream stream = new ByteArrayInputStream("This is a test with the same content each time.".getBytes());
        this.server.expect(this.server.formatUrl(new String[]{"repo", "/path/to/foo.class"}), 200, (InputStream)stream);
        RemoteRepository rr = new RemoteRepository("repo", this.server.formatUrl(new String[]{"repo"}));
        rr = (RemoteRepository)this.client.stores().create((ArtifactStore)rr, "adding test remote", RemoteRepository.class);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InputStream in = ((IndyFoloContentClientModule)this.client.module(IndyFoloContentClientModule.class)).get(trackingId, StoreType.remote, "repo", "/path/to/foo.class");
        IOUtils.copy((InputStream)in, (OutputStream)baos);
        in.close();
        byte[] bytes = baos.toByteArray();
        String md5 = this.md5Hex(bytes);
        String sha256 = this.sha256Hex(bytes);
        MatcherAssert.assertThat((Object)md5, (Matcher)CoreMatchers.equalTo((Object)DigestUtils.md5Hex((byte[])bytes)));
        MatcherAssert.assertThat((Object)sha256, (Matcher)CoreMatchers.equalTo((Object)DigestUtils.sha256Hex((byte[])bytes)));
        this.waitForEventPropagation();
        MatcherAssert.assertThat((Object)((IndyFoloAdminClientModule)this.client.module(IndyFoloAdminClientModule.class)).sealTrackingRecord(trackingId), (Matcher)CoreMatchers.equalTo((Object)true));
        TrackedContentDTO report = ((IndyFoloAdminClientModule)this.client.module(IndyFoloAdminClientModule.class)).getTrackingReport(trackingId);
        MatcherAssert.assertThat((Object)report, (Matcher)CoreMatchers.notNullValue());
        Set downloads = report.getDownloads();
        MatcherAssert.assertThat((Object)downloads, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)downloads.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        TrackedContentEntryDTO entry = (TrackedContentEntryDTO)downloads.iterator().next();
        System.out.println(entry);
        MatcherAssert.assertThat((Object)entry, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)entry.getStoreKey(), (Matcher)CoreMatchers.equalTo((Object)new StoreKey(StoreType.remote, "repo")));
        MatcherAssert.assertThat((Object)entry.getPath(), (Matcher)CoreMatchers.equalTo((Object)"/path/to/foo.class"));
        MatcherAssert.assertThat((Object)entry.getLocalUrl(), (Matcher)CoreMatchers.equalTo((Object)this.client.content().contentUrl(StoreType.remote, "repo", new String[]{"/path/to/foo.class"})));
        MatcherAssert.assertThat((Object)entry.getOriginUrl(), (Matcher)CoreMatchers.equalTo((Object)this.server.formatUrl(new String[]{"repo", "/path/to/foo.class"})));
        MatcherAssert.assertThat((Object)entry.getMd5(), (Matcher)CoreMatchers.equalTo((Object)md5));
        MatcherAssert.assertThat((Object)entry.getSha256(), (Matcher)CoreMatchers.equalTo((Object)sha256));
    }

    @Override
    protected boolean createStandardStores() {
        return false;
    }
}

