/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.folo.ftest.report;

import java.io.File;
import java.io.InputStream;
import org.commonjava.indy.folo.client.IndyFoloAdminClientModule;
import org.commonjava.indy.folo.client.IndyFoloContentClientModule;
import org.commonjava.indy.folo.dto.TrackedContentDTO;
import org.commonjava.indy.folo.dto.TrackedContentEntryDTO;
import org.commonjava.indy.folo.ftest.report.AbstractTrackingReportTest;
import org.commonjava.indy.model.core.StoreKey;
import org.commonjava.indy.model.core.StoreType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;

public abstract class AbstractCacheReportTest
extends AbstractTrackingReportTest {
    protected void doRealTest() throws Exception {
        String trackingId = this.newName();
        String path = "org/commonjava/commonjava/2/commonjava-2.pom";
        InputStream result = ((IndyFoloContentClientModule)this.client.module(IndyFoloContentClientModule.class)).get(trackingId, StoreType.remote, "central", "org/commonjava/commonjava/2/commonjava-2.pom");
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.notNullValue());
        result.close();
        MatcherAssert.assertThat((Object)((IndyFoloAdminClientModule)this.client.module(IndyFoloAdminClientModule.class)).initReport(trackingId), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)((IndyFoloAdminClientModule)this.client.module(IndyFoloAdminClientModule.class)).sealTrackingRecord(trackingId), (Matcher)CoreMatchers.equalTo((Object)true));
        TrackedContentDTO report = ((IndyFoloAdminClientModule)this.client.module(IndyFoloAdminClientModule.class)).getTrackingReport(trackingId);
        MatcherAssert.assertThat((Object)report, (Matcher)CoreMatchers.notNullValue());
        TrackedContentEntryDTO entry = (TrackedContentEntryDTO)report.getDownloads().iterator().next();
        this.doDeletion(entry.getStoreKey(), "org/commonjava/commonjava/2/commonjava-2.pom");
        String filePath = String.format("%s/var/lib/indy/storage/%s-%s/%s", this.fixture.getBootOptions().getHomeDir(), StoreType.remote.name(), "central", "org/commonjava/commonjava/2/commonjava-2.pom");
        File pomFile = new File(filePath);
        MatcherAssert.assertThat((String)"File should be deleted", (Object)pomFile.exists(), (Matcher)CoreMatchers.equalTo((Object)false));
        TrackedContentDTO reportAgain = ((IndyFoloAdminClientModule)this.client.module(IndyFoloAdminClientModule.class)).getTrackingReport(trackingId);
        MatcherAssert.assertThat((Object)reportAgain, (Matcher)CoreMatchers.equalTo((Object)report));
        TrackedContentEntryDTO entryAgain = (TrackedContentEntryDTO)report.getDownloads().iterator().next();
        MatcherAssert.assertThat((Object)entryAgain, (Matcher)CoreMatchers.equalTo((Object)entry));
        MatcherAssert.assertThat((Object)entryAgain.getSha1(), (Matcher)CoreMatchers.equalTo((Object)entry.getSha1()));
        MatcherAssert.assertThat((Object)entryAgain.getSha256(), (Matcher)CoreMatchers.equalTo((Object)entry.getSha256()));
        MatcherAssert.assertThat((Object)entryAgain.getMd5(), (Matcher)CoreMatchers.equalTo((Object)entry.getMd5()));
    }

    protected abstract void doDeletion(StoreKey var1, String var2) throws Exception;
}

