/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.folo.ftest.content.admin;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import org.commonjava.indy.folo.client.IndyFoloAdminClientModule;
import org.commonjava.indy.folo.client.IndyFoloContentClientModule;
import org.commonjava.indy.folo.ftest.report.AbstractTrackingReportTest;
import org.commonjava.indy.model.core.BatchDeleteRequest;
import org.commonjava.indy.model.core.StoreKey;
import org.commonjava.indy.model.core.StoreType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;

public class RemoveFilesInTrackingReportTest
extends AbstractTrackingReportTest {
    @Test
    public void run() throws Exception {
        boolean exists;
        String trackingId = this.newName();
        ByteArrayInputStream stream = new ByteArrayInputStream(("This is a test: " + System.nanoTime()).getBytes());
        String a = "/path/to/1/foo-1.jar";
        String b = "/path/to/2/foo-2.jar";
        String c = "/path/to/3/foo-3.jar";
        for (String path : Arrays.asList("/path/to/1/foo-1.jar", "/path/to/2/foo-2.jar")) {
            ((IndyFoloContentClientModule)this.client.module(IndyFoloContentClientModule.class)).store(trackingId, StoreType.hosted, "test", path, (InputStream)stream);
        }
        StoreKey key = new StoreKey("maven", StoreType.hosted, "test");
        this.client.content().store(key, "/path/to/3/foo-3.jar", (InputStream)stream);
        IndyFoloAdminClientModule adminModule = (IndyFoloAdminClientModule)this.client.module(IndyFoloAdminClientModule.class);
        boolean success = adminModule.sealTrackingRecord(trackingId);
        MatcherAssert.assertThat((Object)success, (Matcher)CoreMatchers.equalTo((Object)true));
        for (String path : Arrays.asList("/path/to/1/foo-1.jar", "/path/to/2/foo-2.jar")) {
            exists = this.client.content().exists(key, path);
            MatcherAssert.assertThat((String)"The file does not exists.", (Object)exists, (Matcher)CoreMatchers.equalTo((Object)true));
        }
        exists = this.client.content().exists(key, "/path/to/3/foo-3.jar");
        MatcherAssert.assertThat((String)"The file does not exists.", (Object)exists, (Matcher)CoreMatchers.equalTo((Object)true));
        BatchDeleteRequest request = new BatchDeleteRequest();
        request.setStoreKey(key);
        request.setTrackingID(trackingId);
        adminModule.deleteFilesFromStoreByTrackingID(request);
        for (String path : Arrays.asList("/path/to/1/foo-1.jar", "/path/to/2/foo-2.jar")) {
            exists = this.client.content().exists(key, path);
            MatcherAssert.assertThat((String)"The file is not removed.", (Object)exists, (Matcher)CoreMatchers.equalTo((Object)false));
        }
        exists = this.client.content().exists(key, "/path/to/3/foo-3.jar");
        MatcherAssert.assertThat((String)"The file does not exists.", (Object)exists, (Matcher)CoreMatchers.equalTo((Object)true));
    }
}

