/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.folo.ftest.content.admin;

import com.fasterxml.jackson.databind.Module;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.commonjava.indy.client.core.IndyClientModule;
import org.commonjava.indy.folo.client.IndyFoloAdminClientModule;
import org.commonjava.indy.folo.client.IndyFoloContentClientModule;
import org.commonjava.indy.ftest.core.AbstractContentManagementTest;
import org.commonjava.indy.model.core.ArtifactStore;
import org.commonjava.indy.model.core.BatchDeleteRequest;
import org.commonjava.indy.model.core.HostedRepository;
import org.commonjava.indy.model.core.StoreKey;
import org.commonjava.indy.model.core.io.IndyObjectMapper;
import org.commonjava.indy.pkg.npm.model.PackageMetadata;
import org.commonjava.indy.pkg.npm.model.VersionMetadata;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class BatchDeletionOfNPMPackagesTest
extends AbstractContentManagementTest {
    @Test
    public void test() throws Exception {
        String trackingId = this.newName();
        InputStream content1 = Thread.currentThread().getContextClassLoader().getResourceAsStream("package-1.5.1.json");
        InputStream content2 = Thread.currentThread().getContextClassLoader().getResourceAsStream("package-1.6.2.json");
        String path = "jquery";
        String firstTarballPath = "jquery/-/jquery-1.5.1.tgz";
        String firstVersionPath = "jquery/1.5.1";
        String secondTarballPath = "jquery/-/jquery-1.6.2.tgz";
        String secondVersionPath = "jquery/1.6.2";
        HostedRepository repo = (HostedRepository)this.client.stores().create((ArtifactStore)new HostedRepository("npm", "test"), "adding npm hosted repo", HostedRepository.class);
        StoreKey storeKey = repo.getKey();
        ((IndyFoloContentClientModule)this.client.module(IndyFoloContentClientModule.class)).store(trackingId, storeKey, "jquery", content1);
        this.client.content().store(storeKey, "jquery", content2);
        IndyFoloAdminClientModule adminModule = (IndyFoloAdminClientModule)this.client.module(IndyFoloAdminClientModule.class);
        boolean success = adminModule.sealTrackingRecord(trackingId);
        Assert.assertTrue((boolean)success);
        InputStream is = this.client.content().get(storeKey, "jquery");
        IndyObjectMapper mapper = new IndyObjectMapper(true, new Module[0]);
        PackageMetadata packageMetadata = (PackageMetadata)mapper.readValue(is, PackageMetadata.class);
        Map versions = packageMetadata.getVersions();
        MatcherAssert.assertThat((Object)versions, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)versions.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)((VersionMetadata)versions.get("1.5.1")).getVersion(), (Matcher)CoreMatchers.equalTo((Object)"1.5.1"));
        MatcherAssert.assertThat((Object)((VersionMetadata)versions.get("1.6.2")).getVersion(), (Matcher)CoreMatchers.equalTo((Object)"1.6.2"));
        MatcherAssert.assertThat((Object)this.client.content().exists(storeKey, "jquery/-/jquery-1.5.1.tgz"), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.client.content().exists(storeKey, "jquery/1.5.1"), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.client.content().exists(storeKey, "jquery/-/jquery-1.6.2.tgz"), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.client.content().exists(storeKey, "jquery/1.6.2"), (Matcher)CoreMatchers.equalTo((Object)true));
        content1.close();
        content2.close();
        BatchDeleteRequest request = new BatchDeleteRequest();
        request.setStoreKey(storeKey);
        request.setTrackingID(trackingId);
        adminModule.deleteFilesFromStoreByTrackingID(request);
        InputStream is_2 = this.client.content().get(storeKey, "jquery");
        packageMetadata = (PackageMetadata)mapper.readValue(is_2, PackageMetadata.class);
        versions = packageMetadata.getVersions();
        MatcherAssert.assertThat((Object)versions, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)versions.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)((VersionMetadata)versions.get("1.6.2")).getVersion(), (Matcher)CoreMatchers.equalTo((Object)"1.6.2"));
        MatcherAssert.assertThat((Object)this.client.content().exists(storeKey, "jquery/-/jquery-1.5.1.tgz"), (Matcher)CoreMatchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.client.content().exists(storeKey, "jquery/1.5.1"), (Matcher)CoreMatchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.client.content().exists(storeKey, "jquery/-/jquery-1.6.2.tgz"), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.client.content().exists(storeKey, "jquery/1.6.2"), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    protected Collection<IndyClientModule> getAdditionalClientModules() {
        return Arrays.asList(new IndyFoloContentClientModule(), new IndyFoloAdminClientModule());
    }
}

