/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.folo.ftest.content;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.commonjava.indy.client.core.IndyClientModule;
import org.commonjava.indy.folo.client.IndyFoloAdminClientModule;
import org.commonjava.indy.folo.client.IndyFoloContentClientModule;
import org.commonjava.indy.folo.dto.TrackedContentDTO;
import org.commonjava.indy.folo.dto.TrackedContentEntryDTO;
import org.commonjava.indy.folo.ftest.content.AbstractFoloContentManagementTest;
import org.commonjava.indy.model.core.ArtifactStore;
import org.commonjava.indy.model.core.HostedRepository;
import org.commonjava.indy.promote.client.IndyPromoteClientModule;
import org.commonjava.indy.promote.model.PathsPromoteRequest;
import org.commonjava.indy.test.fixture.core.CoreServerFixture;
import org.junit.Assert;
import org.junit.Test;

public class StoreAndPromoteFileToTrackedHostedRepoTest
extends AbstractFoloContentManagementTest {
    final String path = "/path/to/foo.class";
    final byte[] bytes = ("This is a test: " + System.nanoTime()).getBytes();

    @Test
    public void run() throws Exception {
        String changelog = "Create test repo";
        IndyFoloContentClientModule folo = (IndyFoloContentClientModule)this.client.module(IndyFoloContentClientModule.class);
        IndyPromoteClientModule promote = (IndyPromoteClientModule)this.client.module(IndyPromoteClientModule.class);
        IndyFoloAdminClientModule foloAdmin = (IndyFoloAdminClientModule)this.client.module(IndyFoloAdminClientModule.class);
        String trackingId = this.newName();
        HostedRepository source = new HostedRepository("maven", trackingId);
        this.client.stores().create((ArtifactStore)source, changelog, HostedRepository.class);
        HostedRepository target = new HostedRepository("maven", "target");
        this.client.stores().create((ArtifactStore)target, changelog, HostedRepository.class);
        ByteArrayInputStream stream = new ByteArrayInputStream(this.bytes);
        folo.store(trackingId, source.getKey(), "/path/to/foo.class", (InputStream)stream);
        foloAdmin.sealTrackingRecord(trackingId);
        PathsPromoteRequest promoteRequest = new PathsPromoteRequest(source.getKey(), target.getKey(), new String[0]);
        promoteRequest.setFireEvents(true);
        promote.promoteByPath(promoteRequest);
        TrackedContentDTO trackingContent = foloAdmin.getRawTrackingContent(trackingId);
        ArrayList list = new ArrayList(trackingContent.getUploads());
        TrackedContentEntryDTO trackedContent = (TrackedContentEntryDTO)list.get(0);
        Assert.assertEquals((Object)target.getKey(), (Object)trackedContent.getStoreKey());
    }

    @Override
    protected Collection<IndyClientModule> getAdditionalClientModules() {
        return Arrays.asList(new IndyFoloContentClientModule(), new IndyFoloAdminClientModule(), new IndyPromoteClientModule());
    }

    protected void initTestData(CoreServerFixture fixture) throws IOException {
        this.writeDataFile("promote/change/tracking-id-formatter.groovy", this.readTestResource(((Object)((Object)this)).getClass().getSimpleName() + "/tracking-id-formatter.groovy"));
    }
}

