/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.folo.ftest.report;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Set;
import org.commonjava.indy.client.core.IndyClientException;
import org.commonjava.indy.client.core.module.IndyContentClientModule;
import org.commonjava.indy.folo.client.IndyFoloAdminClientModule;
import org.commonjava.indy.folo.client.IndyFoloContentClientModule;
import org.commonjava.indy.folo.dto.TrackedContentDTO;
import org.commonjava.indy.folo.ftest.report.AbstractTrackingReportTest;
import org.commonjava.indy.ftest.core.category.EventDependent;
import org.commonjava.indy.model.core.ArtifactStore;
import org.commonjava.indy.model.core.HostedRepository;
import org.commonjava.indy.model.core.StoreType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={EventDependent.class})
public class StoreFileThenDownloadThenUploadAndVerifyInTrackingReportTest
extends AbstractTrackingReportTest {
    final byte[] bytes = ("This is a test: " + System.nanoTime()).getBytes();
    final String path = "/path/to/foo.class";

    @Before
    public void prepareStore() throws Exception {
        HostedRepository r = new HostedRepository("test");
        r = (HostedRepository)this.client.stores().create((ArtifactStore)r, "adding test hosted", HostedRepository.class);
    }

    @Test
    public void runDownloadThenUpload() throws Exception {
        String trackingId = this.newName();
        ((IndyContentClientModule)this.client.module(IndyContentClientModule.class)).store(StoreType.hosted, "test", "/path/to/foo.class", (InputStream)new ByteArrayInputStream(this.bytes));
        IndyFoloContentClientModule module = (IndyFoloContentClientModule)this.client.module(IndyFoloContentClientModule.class);
        module.get(trackingId, StoreType.hosted, "test", "/path/to/foo.class");
        module.store(trackingId, StoreType.hosted, "test", "/path/to/foo.class", (InputStream)new ByteArrayInputStream(this.bytes));
        Thread.sleep(2000L);
    }

    void sealAndCheck(String trackingId) throws IndyClientException {
        IndyFoloAdminClientModule adminModule = (IndyFoloAdminClientModule)this.client.module(IndyFoloAdminClientModule.class);
        boolean success = adminModule.sealTrackingRecord(trackingId);
        Assert.assertThat((Object)success, (Matcher)CoreMatchers.equalTo((Object)true));
        TrackedContentDTO report = adminModule.getTrackingReport(trackingId);
        Assert.assertThat((Object)report, (Matcher)CoreMatchers.notNullValue());
        Set downloads = report.getDownloads();
        Assert.assertThat((Object)downloads, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)downloads.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Set uploads = report.getUploads();
        Assert.assertThat((Object)uploads, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)uploads.size(), (Matcher)CoreMatchers.equalTo((Object)1));
    }
}

