/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.folo.ftest.content;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Set;
import org.commonjava.indy.folo.client.IndyFoloAdminClientModule;
import org.commonjava.indy.folo.client.IndyFoloContentClientModule;
import org.commonjava.indy.folo.dto.TrackedContentDTO;
import org.commonjava.indy.folo.ftest.content.AbstractNPMFoloContentManagementTest;
import org.commonjava.indy.model.core.StoreKey;
import org.commonjava.indy.model.core.StoreType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class VerifyTrackedEntriesForNPMScopedPackageTest
extends AbstractNPMFoloContentManagementTest {
    @Test
    public void verifyTrackedEntryForStore() throws Exception {
        String packageContent = "{\"name\": \"@babel/code-frame\",\n\"description\": \"Generate errors that contain a code frame that point to source locations.\",\n\"license\": \"MIT\"}";
        String packagePath = "@babel/code-frame";
        String trackingId = this.newName();
        this.npmjsServer.expect(this.npmjsServer.formatUrl(new String[]{"@babel/code-frame"}), 200, (InputStream)new ByteArrayInputStream("{\"name\": \"@babel/code-frame\",\n\"description\": \"Generate errors that contain a code frame that point to source locations.\",\n\"license\": \"MIT\"}".getBytes()));
        IndyFoloContentClientModule folo = (IndyFoloContentClientModule)this.client.module(IndyFoloContentClientModule.class);
        StoreKey storeKey = new StoreKey("npm", StoreType.group, "public");
        folo.get(trackingId, storeKey, "@babel/code-frame");
        IndyFoloAdminClientModule adminModule = (IndyFoloAdminClientModule)this.client.module(IndyFoloAdminClientModule.class);
        boolean success = adminModule.sealTrackingRecord(trackingId);
        Assert.assertThat((Object)success, (Matcher)CoreMatchers.equalTo((Object)true));
        TrackedContentDTO report = adminModule.getTrackingReport(trackingId);
        Assert.assertThat((Object)report, (Matcher)CoreMatchers.notNullValue());
        Set downloads = report.getDownloads();
        Assert.assertThat((Object)downloads, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)downloads.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        downloads.stream().forEach(trackedContentEntryDTO -> Assert.assertEquals((Object)"/@babel/code-frame", (Object)trackedContentEntryDTO.getPath()));
    }
}

