/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.folo.ftest.content;

import java.io.InputStream;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.commonjava.indy.folo.client.IndyFoloAdminClientModule;
import org.commonjava.indy.folo.client.IndyFoloContentClientModule;
import org.commonjava.indy.folo.dto.TrackedContentDTO;
import org.commonjava.indy.folo.ftest.content.AbstractFoloContentManagementTest;
import org.commonjava.indy.model.core.StoreType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class GroupMetadataExcludedFromTrackingReportTest
extends AbstractFoloContentManagementTest {
    public void run() throws Exception {
        String trackingId = this.newName();
        String path = "org/commonjava/commonjava/maven-metadata.xml";
        this.centralServer.expect(this.centralServer.formatUrl(new String[]{"org/commonjava/commonjava/maven-metadata.xml"}), 200, Thread.currentThread().getContextClassLoader().getResourceAsStream("folo-content/commonjava-version-metadata.xml"));
        ((IndyFoloAdminClientModule)this.client.module(IndyFoloAdminClientModule.class)).initReport(trackingId);
        InputStream result = ((IndyFoloContentClientModule)this.client.module(IndyFoloContentClientModule.class)).get(trackingId, StoreType.group, "public", "org/commonjava/commonjava/maven-metadata.xml");
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.notNullValue());
        String pom = IOUtils.toString((InputStream)result);
        result.close();
        Assert.assertThat((Object)pom.contains("<version>2</version>"), (Matcher)CoreMatchers.equalTo((Object)true));
        boolean sealed = ((IndyFoloAdminClientModule)this.client.module(IndyFoloAdminClientModule.class)).sealTrackingRecord(trackingId);
        Assert.assertThat((Object)sealed, (Matcher)CoreMatchers.equalTo((Object)true));
        TrackedContentDTO trackingReport = ((IndyFoloAdminClientModule)this.client.module(IndyFoloAdminClientModule.class)).getTrackingReport(trackingId);
        Set downloads = trackingReport.getDownloads();
        Assert.assertThat((Object)(downloads == null || downloads.isEmpty() ? 1 : 0), (Matcher)CoreMatchers.equalTo((Object)true));
    }
}

