/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.folo.ftest.content;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Set;
import org.commonjava.indy.client.core.helper.PathInfo;
import org.commonjava.indy.folo.client.IndyFoloAdminClientModule;
import org.commonjava.indy.folo.client.IndyFoloContentClientModule;
import org.commonjava.indy.folo.dto.TrackedContentDTO;
import org.commonjava.indy.folo.ftest.content.AbstractFoloContentManagementTest;
import org.commonjava.indy.model.core.StoreKey;
import org.commonjava.indy.model.core.StoreType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class DuplicateStoreAndVerifyTrackedRecordTest
extends AbstractFoloContentManagementTest {
    final String path = "/path/to/foo.jar";
    final StoreKey storeKey = new StoreKey("maven", StoreType.hosted, "test");

    @Test
    public void run() throws Exception {
        IndyFoloContentClientModule content = (IndyFoloContentClientModule)this.client.module(IndyFoloContentClientModule.class);
        IndyFoloAdminClientModule admin = (IndyFoloAdminClientModule)this.client.module(IndyFoloAdminClientModule.class);
        String trackingId = this.newName();
        byte[] b = ("This is a test: " + System.nanoTime()).getBytes();
        ByteArrayInputStream stream = new ByteArrayInputStream(b);
        System.out.println(">>> " + b.length);
        byte[] b2 = ("This is another test: " + System.nanoTime()).getBytes();
        ByteArrayInputStream stream2 = new ByteArrayInputStream(b2);
        System.out.println(">>> " + b2.length);
        System.out.println(">>> store stream");
        content.store(trackingId, this.storeKey, "/path/to/foo.jar", (InputStream)stream);
        System.out.println(">>> store stream 2");
        PathInfo store = content.store(trackingId, this.storeKey, "/path/to/foo.jar", (InputStream)stream2);
        System.out.println(">>> Store content length: " + store.getContentLength());
        boolean b1 = admin.sealTrackingRecord(trackingId);
        System.out.println(">>>  seal tracking record: " + b1);
        TrackedContentDTO report = admin.getTrackingReport(trackingId);
        Set uploads = report.getUploads();
        uploads.forEach(et -> {
            System.out.println(">>> md5: " + et.getMd5() + ", size=" + et.getSize());
            System.out.println(">>> B2: " + b2.length);
            System.out.println(">>> B2 long: " + (long)b2.length);
            Assert.assertThat((String)("Mismatched size for: " + et.getPath()), (Object)et.getSize(), (Matcher)CoreMatchers.equalTo((Object)b2.length));
        });
    }
}

