/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.folo.ftest.report;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import org.commonjava.indy.folo.client.IndyFoloAdminClientModule;
import org.commonjava.indy.folo.client.IndyFoloContentClientModule;
import org.commonjava.indy.folo.dto.TrackedContentDTO;
import org.commonjava.indy.folo.dto.TrackedContentEntryDTO;
import org.commonjava.indy.folo.ftest.report.AbstractTrackingReportTest;
import org.commonjava.indy.ftest.core.category.EventDependent;
import org.commonjava.indy.model.core.StoreKey;
import org.commonjava.indy.model.core.StoreType;
import org.commonjava.indy.test.fixture.core.CoreServerFixture;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={EventDependent.class})
public class FoloBackupListenerTest
extends AbstractTrackingReportTest {
    @Test
    public void run() throws Exception {
        String trackingId = this.newName();
        ByteArrayInputStream stream = new ByteArrayInputStream(("This is a test: " + System.nanoTime()).getBytes());
        String path = "/path/to/foo.class";
        ((IndyFoloContentClientModule)this.client.module(IndyFoloContentClientModule.class)).store(trackingId, StoreType.hosted, "test", "/path/to/foo.class", (InputStream)stream);
        IndyFoloAdminClientModule adminModule = (IndyFoloAdminClientModule)this.client.module(IndyFoloAdminClientModule.class);
        boolean success = adminModule.sealTrackingRecord(trackingId);
        Assert.assertThat((Object)success, (Matcher)CoreMatchers.equalTo((Object)true));
        TrackedContentDTO report = adminModule.getTrackingReport(trackingId);
        Assert.assertThat((Object)report, (Matcher)CoreMatchers.notNullValue());
        Set uploads = report.getUploads();
        Assert.assertThat((Object)uploads, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)uploads.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        TrackedContentEntryDTO entry = (TrackedContentEntryDTO)uploads.iterator().next();
        System.out.println(entry);
        Assert.assertThat((Object)entry, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)entry.getStoreKey(), (Matcher)CoreMatchers.equalTo((Object)new StoreKey(StoreType.hosted, "test")));
        Assert.assertThat((Object)entry.getPath(), (Matcher)CoreMatchers.equalTo((Object)"/path/to/foo.class"));
        Assert.assertThat((Object)entry.getLocalUrl(), (Matcher)CoreMatchers.equalTo((Object)this.client.content().contentUrl(StoreType.hosted, "test", new String[]{"/path/to/foo.class"})));
        Assert.assertThat((Object)entry.getOriginUrl(), (Matcher)CoreMatchers.nullValue());
        File f1 = new File(this.dataDir, "folo/bak/sealed/" + trackingId);
        Assert.assertTrue((boolean)f1.exists());
        File f2 = new File(this.dataDir, "folo/bak/sealed");
        this.assertDumped(f2);
    }

    private void assertDumped(File dir) {
        Assert.assertTrue((boolean)dir.isDirectory());
        String[] files = dir.list();
        this.logger.debug("Dump backup files, size: {}, names: {}", (Object)files.length, (Object)files);
    }

    protected void initTestData(CoreServerFixture fixture) throws IOException {
    }
}

