/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.folo.ftest.report;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.commons.io.IOUtils;
import org.commonjava.indy.client.core.IndyClientException;
import org.commonjava.indy.folo.FoloUtils;
import org.commonjava.indy.folo.client.IndyFoloAdminClientModule;
import org.commonjava.indy.folo.dto.TrackedContentDTO;
import org.commonjava.indy.folo.dto.TrackedContentEntryDTO;
import org.commonjava.indy.folo.dto.TrackingIdsDTO;
import org.commonjava.indy.folo.ftest.report.RetrieveFileAndVerifyInTrackingReportTest;
import org.commonjava.indy.folo.model.TrackedContent;
import org.commonjava.indy.ftest.core.category.EventDependent;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={EventDependent.class})
public class ExportAndImportTrackingReportTest
extends RetrieveFileAndVerifyInTrackingReportTest {
    static final String repoId = "repo";
    static final String FOLO_TYPE_SEALED = "sealed";
    static final String path1 = "/path/1/foo.class";
    static final String path2 = "/path/2/foo.class";

    @Override
    @Test
    public void run() throws Exception {
        String[] ret = this.retrieveAndSeal(repoId, path1, "This is a test.");
        String trackingId_1 = ret[0];
        ret = this.retrieveAndSeal(repoId, path2, "This is a another test.");
        String trackingId_2 = ret[0];
        IndyFoloAdminClientModule adminClientModule = (IndyFoloAdminClientModule)this.client.module(IndyFoloAdminClientModule.class);
        InputStream stream = adminClientModule.exportTrackingReportZip();
        File zipFile = new File(this.dataDir, "folo/folo-sealed.zip");
        Assert.assertTrue((boolean)zipFile.exists());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)stream, (OutputStream)baos);
        byte[] bytes = baos.toByteArray();
        stream.close();
        ArrayList<TrackedContent> list = new ArrayList<TrackedContent>();
        FoloUtils.readZipInputStreamAnd((InputStream)new ByteArrayInputStream(bytes), record -> list.add((TrackedContent)record));
        List<String> trackingIds = this.check(list);
        Assert.assertTrue((boolean)trackingIds.contains(trackingId_1));
        Assert.assertTrue((boolean)trackingIds.contains(trackingId_2));
        trackingIds.forEach(id -> {
            try {
                adminClientModule.clearTrackingRecord(id);
            }
            catch (IndyClientException e) {
                e.printStackTrace();
            }
        });
        TrackingIdsDTO idsDTO = adminClientModule.getTrackingIds(FOLO_TYPE_SEALED);
        TestCase.assertNull((Object)idsDTO);
        adminClientModule.importTrackingReportZip((InputStream)new ByteArrayInputStream(bytes));
        idsDTO = adminClientModule.getTrackingIds(FOLO_TYPE_SEALED);
        ExportAndImportTrackingReportTest.checkIdsDTO(idsDTO, trackingIds, adminClientModule);
    }

    private List<String> check(List<TrackedContent> list) {
        Assert.assertEquals((long)2L, (long)list.size());
        TrackedContent trackedContent_1 = list.get(0);
        Assert.assertTrue((boolean)trackedContent_1.getUploads().isEmpty());
        Set downloads = trackedContent_1.getDownloads();
        Assert.assertEquals((long)1L, (long)downloads.size());
        System.out.println(">>>> " + downloads);
        TrackedContent trackedContent_2 = list.get(1);
        Assert.assertTrue((boolean)trackedContent_2.getUploads().isEmpty());
        downloads = trackedContent_2.getDownloads();
        Assert.assertEquals((long)1L, (long)downloads.size());
        System.out.println(">>>> " + downloads);
        ArrayList<String> trackingIds = new ArrayList<String>();
        list.forEach(trackedContent -> trackingIds.add(trackedContent.getKey().getId()));
        return trackingIds;
    }

    static void checkIdsDTO(TrackingIdsDTO idsDTO, List<String> expectedIds, IndyFoloAdminClientModule adminClientModule) {
        Assert.assertTrue((boolean)idsDTO.getSealed().containsAll(expectedIds));
        Assert.assertEquals((long)2L, (long)idsDTO.getSealed().size());
        ArrayList ex = new ArrayList();
        idsDTO.getSealed().forEach(id -> {
            try {
                TrackedContentDTO report = adminClientModule.getTrackingReport(id);
                Assert.assertNotNull((Object)report);
                System.out.println(">>>> " + report.getKey() + ", " + report.getDownloads());
                Assert.assertTrue((boolean)expectedIds.contains(report.getKey().getId()));
                Assert.assertTrue((!report.getDownloads().isEmpty() ? 1 : 0) != 0);
                Assert.assertEquals((long)1L, (long)report.getDownloads().size());
                ArrayList list = new ArrayList(report.getDownloads());
                TrackedContentEntryDTO entryDTO = (TrackedContentEntryDTO)list.get(0);
                Assert.assertTrue((entryDTO.getPath().contains(path1) || entryDTO.getPath().contains(path2) ? 1 : 0) != 0);
                Assert.assertTrue((boolean)entryDTO.getStoreKey().getName().equals(repoId));
            }
            catch (IndyClientException e) {
                ex.add(e);
            }
        });
        Assert.assertTrue((boolean)ex.isEmpty());
    }
}

