/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.folo.ftest.content;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Set;
import org.commonjava.indy.folo.client.IndyFoloAdminClientModule;
import org.commonjava.indy.folo.client.IndyFoloContentClientModule;
import org.commonjava.indy.folo.dto.TrackedContentDTO;
import org.commonjava.indy.folo.ftest.content.AbstractFoloContentManagementTest;
import org.commonjava.indy.model.core.StoreKey;
import org.commonjava.indy.model.core.StoreType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class DuplicateStoreAndVerifyTrackedRecordTest
extends AbstractFoloContentManagementTest {
    final String path = "/path/to/foo.jar";
    final StoreKey storeKey = new StoreKey("maven", StoreType.hosted, "test");

    @Test
    public void run() throws Exception {
        IndyFoloContentClientModule content = (IndyFoloContentClientModule)this.client.module(IndyFoloContentClientModule.class);
        IndyFoloAdminClientModule admin = (IndyFoloAdminClientModule)this.client.module(IndyFoloAdminClientModule.class);
        String trackingId = this.newName();
        byte[] b = ("This is a test: " + System.nanoTime()).getBytes();
        ByteArrayInputStream stream = new ByteArrayInputStream(b);
        byte[] b2 = ("This is another test: " + System.nanoTime()).getBytes();
        ByteArrayInputStream stream2 = new ByteArrayInputStream(b2);
        System.out.println(">>> store stream");
        content.store(trackingId, this.storeKey, "/path/to/foo.jar", (InputStream)stream);
        System.out.println(">>> store stream 2");
        content.store(trackingId, this.storeKey, "/path/to/foo.jar", (InputStream)stream2);
        admin.sealTrackingRecord(trackingId);
        TrackedContentDTO report = admin.getTrackingReport(trackingId);
        Set uploads = report.getUploads();
        uploads.forEach(et -> {
            System.out.println(">>> md5: " + et.getMd5() + ", size=" + et.getSize());
            Assert.assertThat((String)("Mismatched size for: " + et.getPath()), (Object)et.getSize(), (Matcher)CoreMatchers.equalTo((Object)b2.length));
        });
    }
}

