/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.folo.ftest.content;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.commonjava.indy.folo.client.IndyFoloContentClientModule;
import org.commonjava.indy.folo.ftest.content.AbstractNPMFoloContentManagementTest;
import org.commonjava.indy.model.core.StoreKey;
import org.commonjava.indy.model.core.StoreType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class DownloadFromTrackedNPMRemoteRepoTest
extends AbstractNPMFoloContentManagementTest {
    @Test
    public void downloadFileFromRemoteRepository() throws Exception {
        String packageContent = "{\"name\": \"jquery\",\n\"description\": \"JavaScript library for DOM operations\",\n\"license\": \"MIT\"}";
        String versionContent = "{\"name\": \"jquery\",\n\"url\": \"jquery.com\",\n\"version\": \"1.1.0\"}";
        String packagePath = "jquery";
        String versionPath = "jquery/1.1.0";
        String trackingId = this.newName();
        this.npmjsServer.expect(this.npmjsServer.formatUrl(new String[]{"jquery"}), 200, (InputStream)new ByteArrayInputStream("{\"name\": \"jquery\",\n\"description\": \"JavaScript library for DOM operations\",\n\"license\": \"MIT\"}".getBytes()));
        this.npmjsServer.expect(this.npmjsServer.formatUrl(new String[]{"jquery/1.1.0"}), 200, (InputStream)new ByteArrayInputStream("{\"name\": \"jquery\",\n\"url\": \"jquery.com\",\n\"version\": \"1.1.0\"}".getBytes()));
        StoreKey storeKey = new StoreKey("npm", StoreType.remote, "npmjs");
        IndyFoloContentClientModule folo = (IndyFoloContentClientModule)this.client.module(IndyFoloContentClientModule.class);
        InputStream packageStream = folo.get(trackingId, storeKey, "jquery");
        InputStream versionStream = folo.get(trackingId, storeKey, "jquery/1.1.0");
        Assert.assertThat((Object)packageStream, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)versionStream, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)IOUtils.toString((InputStream)packageStream), (Matcher)CoreMatchers.equalTo((Object)"{\"name\": \"jquery\",\n\"description\": \"JavaScript library for DOM operations\",\n\"license\": \"MIT\"}"));
        Assert.assertThat((Object)IOUtils.toString((InputStream)versionStream), (Matcher)CoreMatchers.equalTo((Object)"{\"name\": \"jquery\",\n\"url\": \"jquery.com\",\n\"version\": \"1.1.0\"}"));
        packageStream.close();
        versionStream.close();
    }
}

