/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.folo.ftest.content;

import java.util.Arrays;
import java.util.Collection;
import org.commonjava.indy.client.core.IndyClientModule;
import org.commonjava.indy.folo.client.IndyFoloAdminClientModule;
import org.commonjava.indy.folo.client.IndyFoloContentClientModule;
import org.commonjava.indy.ftest.core.AbstractIndyFunctionalTest;
import org.commonjava.indy.ftest.core.category.EventDependent;
import org.commonjava.indy.model.core.ArtifactStore;
import org.commonjava.indy.model.core.Group;
import org.commonjava.indy.model.core.HostedRepository;
import org.commonjava.indy.model.core.RemoteRepository;
import org.commonjava.indy.model.core.StoreKey;
import org.commonjava.indy.model.core.StoreType;
import org.commonjava.test.http.expect.ExpectationServer;
import org.junit.Before;
import org.junit.Rule;
import org.junit.experimental.categories.Category;

@Category(value={EventDependent.class})
public class AbstractNPMFoloContentManagementTest
extends AbstractIndyFunctionalTest {
    protected static final String STORE = "test";
    protected static final String NPMJS = "npmjs";
    protected static final String PUBLIC = "public";
    @Rule
    public ExpectationServer npmjsServer = new ExpectationServer();

    @Before
    public void before() throws Exception {
        String changelog = "Setup: " + this.name.getMethodName();
        HostedRepository hosted = (HostedRepository)this.client.stores().create((ArtifactStore)new HostedRepository("npm", STORE), changelog, HostedRepository.class);
        RemoteRepository npmjs = null;
        StoreKey npmjsKey = new StoreKey("npm", StoreType.remote, NPMJS);
        if (this.client.stores().exists(npmjsKey)) {
            this.client.stores().delete(npmjsKey, "removing existing remote:npmjs definition");
        }
        npmjs = (RemoteRepository)this.client.stores().create((ArtifactStore)new RemoteRepository("npm", NPMJS, this.npmjsServer.getBaseUri()), changelog, RemoteRepository.class);
        StoreKey publicGrpKey = new StoreKey("npm", StoreType.group, PUBLIC);
        Group g = this.client.stores().exists(publicGrpKey) ? (Group)this.client.stores().load(publicGrpKey, Group.class) : (Group)this.client.stores().create((ArtifactStore)new Group("npm", PUBLIC, new StoreKey[0]), changelog, Group.class);
        g.setConstituents(Arrays.asList(hosted.getKey(), npmjs.getKey()));
        this.client.stores().update((ArtifactStore)g, changelog);
    }

    protected Collection<IndyClientModule> getAdditionalClientModules() {
        return Arrays.asList(new IndyFoloContentClientModule(), new IndyFoloAdminClientModule());
    }
}

