/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.folo.ftest.urls;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.commonjava.indy.client.core.IndyClientException;
import org.commonjava.indy.client.core.IndyClientHttp;
import org.commonjava.indy.client.core.IndyClientModule;
import org.commonjava.indy.client.core.module.IndyRawHttpModule;
import org.commonjava.indy.folo.client.IndyFoloAdminClientModule;
import org.commonjava.indy.folo.client.IndyFoloContentClientModule;
import org.commonjava.indy.ftest.core.AbstractIndyFunctionalTest;
import org.commonjava.indy.model.core.ArtifactStore;
import org.commonjava.indy.model.core.Group;
import org.commonjava.indy.model.core.HostedRepository;
import org.commonjava.indy.model.core.StoreKey;
import org.commonjava.indy.model.core.StoreType;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;

public abstract class AbstractFoloUrlsTest
extends AbstractIndyFunctionalTest {
    protected static final String STORE = "test";
    protected static final String PUBLIC = "public";
    @Rule
    public TestName name = new TestName();
    protected IndyFoloContentClientModule content;
    protected IndyFoloAdminClientModule admin;

    @Before
    public void before() throws Exception {
        Group g;
        this.content = (IndyFoloContentClientModule)this.client.module(IndyFoloContentClientModule.class);
        this.admin = (IndyFoloAdminClientModule)this.client.module(IndyFoloAdminClientModule.class);
        if (!this.createStandardTestStructures()) {
            return;
        }
        String changelog = "Create test structures";
        HostedRepository hosted = (HostedRepository)this.client.stores().create((ArtifactStore)new HostedRepository(STORE), "Create test structures", HostedRepository.class);
        if (this.client.stores().exists(StoreType.group, PUBLIC)) {
            System.out.println("Loading pre-existing public group.");
            g = (Group)this.client.stores().load(StoreType.group, PUBLIC, Group.class);
        } else {
            System.out.println("Creating new group 'public'");
            g = (Group)this.client.stores().create((ArtifactStore)new Group(PUBLIC, new StoreKey[0]), "Create test structures", Group.class);
        }
        g.setConstituents(Collections.singletonList(hosted.getKey()));
        this.client.stores().update((ArtifactStore)g, "Create test structures");
    }

    protected boolean createStandardTestStructures() {
        return true;
    }

    protected IndyClientHttp getHttp() throws IndyClientException {
        return ((IndyRawHttpModule)this.client.module(IndyRawHttpModule.class)).getHttp();
    }

    protected Collection<IndyClientModule> getAdditionalClientModules() {
        return Arrays.asList(new IndyRawHttpModule(), new IndyFoloAdminClientModule(), new IndyFoloContentClientModule());
    }
}

