/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.folo.ftest.report;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.commonjava.indy.client.core.util.UrlUtils;
import org.commonjava.indy.folo.client.IndyFoloAdminClientModule;
import org.commonjava.indy.folo.client.IndyFoloContentClientModule;
import org.commonjava.indy.folo.dto.TrackedContentDTO;
import org.commonjava.indy.folo.dto.TrackedContentEntryDTO;
import org.commonjava.indy.folo.ftest.report.AbstractTrackingReportTest;
import org.commonjava.indy.ftest.core.category.BytemanTest;
import org.commonjava.indy.model.core.ArtifactStore;
import org.commonjava.indy.model.core.RemoteRepository;
import org.commonjava.indy.model.core.StoreKey;
import org.commonjava.indy.model.core.StoreType;
import org.commonjava.test.http.expect.ExpectationServer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.byteman.contrib.bmunit.BMRule;
import org.jboss.byteman.contrib.bmunit.BMRules;
import org.jboss.byteman.contrib.bmunit.BMUnitConfig;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=BMUnitRunner.class)
@BMUnitConfig(debug=true)
@Category(value={BytemanTest.class})
public class UseChecksumFromTransferDecoratorForTrackingRecord_Sha1FileTest
extends AbstractTrackingReportTest {
    @Rule
    public ExpectationServer server = new ExpectationServer();

    @BMRules(rules={@BMRule(name="setup_metadata_countdown", targetClass="^org.commonjava.indy.content.ContentDigester", isInterface=true, targetMethod="<init>", targetLocation="ENTRY", action="System.out.println(\"SETUP COUNTDOWN\"); createCountDown(\"COUNTDOWN\", 1);"), @BMRule(name="prevent_successive_metadata_additions", targetClass="^org.commonjava.indy.content.ContentDigester", isInterface=true, targetMethod="addMetadata", targetLocation="ENTRY", binding="path:String = $1.getPath();", condition="path.endsWith(\"path/to/foo.class\") && countDown(\"COUNTDOWN\")", action="System.out.println(\"RETURN NULL\"); return null;")})
    @Test
    public void run() throws Exception {
        String trackingId = this.newName();
        String repoId = "repo";
        String path = "/org/bar/foo/1/foo-1.pom.sha1";
        ByteArrayInputStream stream = new ByteArrayInputStream(DigestUtils.md5((String)"This is a test with the same content each time."));
        this.server.expect(this.server.formatUrl(new String[]{"repo", "/org/bar/foo/1/foo-1.pom.sha1"}), 200, (InputStream)stream);
        RemoteRepository rr = new RemoteRepository("repo", this.server.formatUrl(new String[]{"repo"}));
        rr = (RemoteRepository)this.client.stores().create((ArtifactStore)rr, "adding test remote", RemoteRepository.class);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InputStream in = ((IndyFoloContentClientModule)this.client.module(IndyFoloContentClientModule.class)).get(trackingId, StoreType.remote, "repo", "/org/bar/foo/1/foo-1.pom.sha1");
        IOUtils.copy((InputStream)in, (OutputStream)baos);
        in.close();
        byte[] bytes = baos.toByteArray();
        String md5 = this.md5Hex(bytes);
        String sha256 = this.sha256Hex(bytes);
        Assert.assertThat((Object)md5, (Matcher)CoreMatchers.equalTo((Object)DigestUtils.md5Hex((byte[])bytes)));
        Assert.assertThat((Object)sha256, (Matcher)CoreMatchers.equalTo((Object)DigestUtils.sha256Hex((byte[])bytes)));
        this.waitForEventPropagation();
        Assert.assertThat((Object)((IndyFoloAdminClientModule)this.client.module(IndyFoloAdminClientModule.class)).sealTrackingRecord(trackingId), (Matcher)CoreMatchers.equalTo((Object)true));
        TrackedContentDTO report = ((IndyFoloAdminClientModule)this.client.module(IndyFoloAdminClientModule.class)).getTrackingReport(trackingId);
        Assert.assertThat((Object)report, (Matcher)CoreMatchers.notNullValue());
        Set downloads = report.getDownloads();
        Assert.assertThat((Object)downloads, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)downloads.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        TrackedContentEntryDTO entry = (TrackedContentEntryDTO)downloads.iterator().next();
        System.out.println(entry);
        Assert.assertThat((Object)entry, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)entry.getStoreKey(), (Matcher)CoreMatchers.equalTo((Object)new StoreKey(StoreType.remote, "repo")));
        Assert.assertThat((Object)entry.getPath(), (Matcher)CoreMatchers.equalTo((Object)"/org/bar/foo/1/foo-1.pom.sha1"));
        Assert.assertThat((Object)entry.getLocalUrl(), (Matcher)CoreMatchers.equalTo((Object)UrlUtils.buildUrl((String)this.client.getBaseUrl(), (String[])new String[]{StoreType.remote.singularEndpointName(), "repo", "/org/bar/foo/1/foo-1.pom.sha1"})));
        Assert.assertThat((Object)entry.getOriginUrl(), (Matcher)CoreMatchers.equalTo((Object)this.server.formatUrl(new String[]{"repo", "/org/bar/foo/1/foo-1.pom.sha1"})));
        Assert.assertThat((Object)entry.getMd5(), (Matcher)CoreMatchers.equalTo((Object)md5));
        Assert.assertThat((Object)entry.getSha256(), (Matcher)CoreMatchers.equalTo((Object)sha256));
    }

    @Override
    protected boolean createStandardStores() {
        return false;
    }
}

