/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.folo.ftest.content.admin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.commonjava.indy.folo.client.IndyFoloAdminClientModule;
import org.commonjava.indy.folo.client.IndyFoloContentClientModule;
import org.commonjava.indy.folo.ftest.content.AbstractFoloContentManagementTest;
import org.commonjava.indy.ftest.core.category.EventDependent;
import org.commonjava.indy.model.core.StoreType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={EventDependent.class})
public class DownloadFromTrackedAndRetrieveInRepoZipTest
extends AbstractFoloContentManagementTest {
    @Test
    public void run() throws Exception {
        String trackingId = this.newName();
        String path = "org/commonjava/commonjava/2/commonjava-2.pom";
        InputStream result = ((IndyFoloContentClientModule)this.client.module(IndyFoloContentClientModule.class)).get(trackingId, StoreType.remote, "central", path);
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.notNullValue());
        String pom = IOUtils.toString((InputStream)result);
        result.close();
        Assert.assertThat((Object)pom.contains("<groupId>org.commonjava</groupId>"), (Matcher)CoreMatchers.equalTo((Object)true));
        IndyFoloAdminClientModule module = (IndyFoloAdminClientModule)this.client.module(IndyFoloAdminClientModule.class);
        boolean success = module.sealTrackingRecord(trackingId);
        Assert.assertThat((Object)success, (Matcher)CoreMatchers.equalTo((Object)true));
        result = module.getTrackingRepoZip(trackingId);
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.notNullValue());
        File f = this.getTemp().newFile("downloaded.zip");
        try (FileOutputStream fos = new FileOutputStream(f);){
            IOUtils.copy((InputStream)result, (OutputStream)fos);
        }
        ZipFile zf = new ZipFile(f);
        ZipEntry entry = zf.getEntry(path);
        Assert.assertThat((Object)entry, (Matcher)CoreMatchers.notNullValue());
        try (InputStream stream = zf.getInputStream(entry);){
            String fromZip = IOUtils.toString((InputStream)stream);
            Assert.assertThat((String)"zip contents differ from direct download!", (Object)fromZip, (Matcher)CoreMatchers.equalTo((Object)pom));
        }
    }
}

