/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.folo.ftest.urls;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Set;
import org.commonjava.indy.folo.dto.TrackedContentDTO;
import org.commonjava.indy.folo.dto.TrackedContentEntryDTO;
import org.commonjava.indy.folo.ftest.urls.AbstractFoloUrlsTest;
import org.commonjava.indy.model.core.StoreType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class StoreOneTrackedAndVerifyUrlInReportTest
extends AbstractFoloUrlsTest {
    @Test
    public void storeOneFileAndVerifyItInParentDirectoryListing() throws Exception {
        byte[] data = "this is a test".getBytes();
        ByteArrayInputStream stream = new ByteArrayInputStream(data);
        String root = "/path/to/";
        String path = "/path/to/foo.txt";
        String trackingId = "tracker";
        this.content.store("tracker", StoreType.hosted, "test", "/path/to/foo.txt", (InputStream)stream);
        TrackedContentDTO report = this.admin.getTrackingReport("tracker", StoreType.hosted, "test");
        Set uploads = report.getUploads();
        for (TrackedContentEntryDTO upload : uploads) {
            String uploadPath = upload.getPath();
            String localUrl = this.client.content().contentUrl(StoreType.hosted, "test", new String[]{uploadPath});
            Assert.assertThat((String)("Incorrect local URL for upload: '" + uploadPath + "'"), (Object)upload.getLocalUrl(), (Matcher)CoreMatchers.equalTo((Object)localUrl));
        }
    }
}

