/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.folo.ftest.content;

import java.io.File;
import java.io.InputStream;
import java.util.Date;
import org.commonjava.indy.folo.client.IndyFoloContentClientModule;
import org.commonjava.indy.folo.ftest.content.AbstractFoloContentManagementTest;
import org.commonjava.indy.model.core.ArtifactStore;
import org.commonjava.indy.model.core.RemoteRepository;
import org.commonjava.indy.model.core.StoreType;
import org.commonjava.test.http.expect.ExpectationServer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class AutomaticPomDownloadTest
extends AbstractFoloContentManagementTest {
    @Rule
    public ExpectationServer server = new ExpectationServer();

    @Test
    public void downloadJarAndCheckIfPomWasDownloaded() throws Exception {
        String repoId = "test-repo";
        String pathFormat = "/org/foo/bar/1.0/bar-1.0.%s";
        String jarPath = String.format("/org/foo/bar/1.0/bar-1.0.%s", "jar");
        String jarUrl = this.server.formatUrl(new String[]{"test-repo", jarPath});
        String pomPath = String.format("/org/foo/bar/1.0/bar-1.0.%s", "pom");
        String pomUrl = this.server.formatUrl(new String[]{"test-repo", pomPath});
        String datetime = new Date().toString();
        this.server.expect(pomUrl, 200, String.format("pom %s", datetime));
        this.server.expect(jarUrl, 200, String.format("jar %s", datetime));
        String changelog = "Setup: " + this.name.getMethodName();
        this.client.stores().create((ArtifactStore)new RemoteRepository("test-repo", this.server.formatUrl(new String[]{"test-repo"})), changelog, RemoteRepository.class);
        File pomFile = new File(String.format("%s/var/lib/indy/storage/%s-%s%s", this.fixture.getBootOptions().getIndyHome(), StoreType.remote.name(), "test-repo", pomPath));
        Assert.assertThat((Object)pomFile.exists(), (Matcher)CoreMatchers.equalTo((Object)false));
        IndyFoloContentClientModule clientModule = (IndyFoloContentClientModule)this.client.module(IndyFoloContentClientModule.class);
        InputStream result = clientModule.get(this.newName(), StoreType.remote, "test-repo", jarPath);
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.notNullValue());
        result.close();
        Thread.sleep(1000L);
        Assert.assertThat((Object)pomFile.exists(), (Matcher)CoreMatchers.equalTo((Object)true));
    }
}

