/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.depgraph.ftest;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.commonjava.cartographer.Cartographer;
import org.commonjava.indy.boot.BootStatus;
import org.commonjava.indy.boot.IndyBootException;
import org.commonjava.indy.client.core.Indy;
import org.commonjava.indy.client.core.IndyClientModule;
import org.commonjava.indy.client.core.module.IndyRawObjectMapperModule;
import org.commonjava.indy.depgraph.client.DepgraphIndyClientModule;
import org.commonjava.indy.depgraph.impl.ClientCartographer;
import org.commonjava.indy.model.core.ArtifactStore;
import org.commonjava.indy.model.core.RemoteRepository;
import org.commonjava.indy.model.core.StoreKey;
import org.commonjava.indy.model.core.StoreType;
import org.commonjava.indy.test.fixture.core.CoreServerFixture;
import org.commonjava.maven.cartographer.ftest.CartoTCKDriver;
import org.commonjava.test.http.stream.StreamServer;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndyCartoTCKDriver
implements CartoTCKDriver {
    protected Indy client;
    protected CoreServerFixture fixture;
    private Set<StreamServer> servers = new HashSet<StreamServer>();
    private ClientCartographer carto;
    private File etcDir;

    public Cartographer start(TemporaryFolder temp) throws Exception {
        this.fixture = this.newServerFixture(temp);
        this.fixture.start();
        if (!this.fixture.isStarted()) {
            BootStatus status = this.fixture.getBootStatus();
            throw new IllegalStateException("server fixture failed to boot.", status.getError());
        }
        this.client = new Indy(this.fixture.getUrl(), new IndyClientModule[]{new DepgraphIndyClientModule(), new IndyRawObjectMapperModule()}).connect();
        this.carto = new ClientCartographer(this.client);
        return this.carto;
    }

    public void stop() {
        IOUtils.closeQuietly((Closeable)this.fixture);
        if (this.carto != null) {
            this.carto.close();
        }
        IOUtils.closeQuietly((Closeable)this.client);
        this.servers.forEach(StreamServer::stop);
    }

    public void createRepoAlias(String alias, String repoResource) throws Exception {
        String url = repoResource;
        if (repoResource.startsWith("file:") || repoResource.startsWith("jar:")) {
            StreamServer server = new StreamServer(repoResource).start();
            this.servers.add(server);
            url = server.getBaseUri();
        }
        this.client.stores().create((ArtifactStore)new RemoteRepository(alias, url), "Adding test repo: " + alias, RemoteRepository.class);
        this.carto.setSourceAlias(alias, new StoreKey(StoreType.remote, alias).toString());
    }

    protected CoreServerFixture newServerFixture(TemporaryFolder temp) throws IndyBootException, IOException {
        CoreServerFixture fixture = new CoreServerFixture(temp);
        this.etcDir = new File(fixture.getBootOptions().getIndyHome(), "etc/indy");
        this.writeConfigFile("conf.d/scheduler.conf", "[scheduler]\nenabled=false");
        return fixture;
    }

    protected void writeConfigFile(String confPath, String contents) throws IOException {
        Logger logger = LoggerFactory.getLogger(this.getClass());
        logger.info("Writing configuration to: {}\n\n{}\n\n", (Object)confPath, (Object)contents);
        File confFile = new File(this.etcDir, confPath);
        confFile.getParentFile().mkdirs();
        FileUtils.write((File)confFile, (CharSequence)contents);
    }
}

