/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.depgraph.ftest.testutil;

import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.commonjava.indy.depgraph.jaxrs.util.JaxRsPresetParamParser;
import org.commonjava.indy.depgraph.util.PresetParameterParser;
import org.commonjava.indy.inject.TestData;
import org.commonjava.maven.galley.TransferManager;
import org.commonjava.maven.galley.maven.ArtifactManager;
import org.commonjava.maven.galley.maven.ArtifactMetadataManager;
import org.commonjava.maven.galley.maven.internal.ArtifactManagerImpl;
import org.commonjava.maven.galley.maven.internal.ArtifactMetadataManagerImpl;
import org.commonjava.maven.galley.maven.internal.defaults.StandardMaven304PluginDefaults;
import org.commonjava.maven.galley.maven.internal.defaults.StandardMavenPluginImplications;
import org.commonjava.maven.galley.maven.internal.type.StandardTypeMapper;
import org.commonjava.maven.galley.maven.internal.version.VersionResolverImpl;
import org.commonjava.maven.galley.maven.model.view.XPathManager;
import org.commonjava.maven.galley.maven.parse.MavenMetadataReader;
import org.commonjava.maven.galley.maven.parse.MavenPomReader;
import org.commonjava.maven.galley.maven.parse.XMLInfrastructure;
import org.commonjava.maven.galley.maven.spi.defaults.MavenPluginDefaults;
import org.commonjava.maven.galley.maven.spi.defaults.MavenPluginImplications;
import org.commonjava.maven.galley.maven.spi.type.TypeMapper;
import org.commonjava.maven.galley.maven.spi.version.VersionResolver;
import org.commonjava.maven.galley.spi.transport.LocationExpander;

@ApplicationScoped
public class TestProvider {
    private PresetParameterParser presetParser;
    private MavenPomReader pomReader;
    private MavenMetadataReader metadataReader;
    private ArtifactManager artifacts;
    private ArtifactMetadataManager metadataManager;
    private MavenPluginImplications pluginImplications;
    private MavenPluginDefaults pluginDefaults;
    private XPathManager xpath;
    @Inject
    private LocationExpander locations;
    private XMLInfrastructure xml;
    private VersionResolver versionResolver;
    private TypeMapper mapper;
    @Inject
    private TransferManager transfers;

    @PostConstruct
    public void init() {
        this.xml = new XMLInfrastructure();
        this.xpath = new XPathManager();
        this.presetParser = new JaxRsPresetParamParser();
        this.pluginImplications = new StandardMavenPluginImplications(this.xml);
        this.pluginDefaults = new StandardMaven304PluginDefaults();
        this.mapper = new StandardTypeMapper();
        this.metadataManager = new ArtifactMetadataManagerImpl(this.transfers, this.locations);
        this.metadataReader = new MavenMetadataReader(this.xml, this.locations, this.metadataManager, this.xpath);
        this.versionResolver = new VersionResolverImpl(this.metadataReader);
        this.artifacts = new ArtifactManagerImpl(this.transfers, this.locations, this.mapper, this.versionResolver);
        this.pomReader = new MavenPomReader(this.xml, this.locations, this.artifacts, this.xpath, this.pluginDefaults, this.pluginImplications);
    }

    @Produces
    @Default
    @TestData
    public PresetParameterParser getPresetParameterParser() {
        return this.presetParser;
    }

    @Produces
    @Default
    @TestData
    public ArtifactManager getArtifactManager() {
        return this.artifacts;
    }

    @Produces
    @Default
    @TestData
    public MavenPomReader getMavenPomReader() {
        return this.pomReader;
    }
}

