/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.folo.change;

import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.commonjava.indy.data.StoreDataManager;
import org.commonjava.indy.folo.conf.FoloConfig;
import org.commonjava.indy.folo.data.FoloRecord;
import org.commonjava.indy.folo.model.TrackedContent;
import org.commonjava.indy.folo.model.TrackingKey;
import org.commonjava.indy.model.core.StoreKey;
import org.commonjava.indy.model.core.StoreType;
import org.commonjava.indy.promote.change.PromoteChangeManager;
import org.commonjava.indy.promote.change.event.PathsPromoteCompleteEvent;
import org.commonjava.indy.promote.change.event.PromoteCompleteEvent;
import org.commonjava.indy.promote.model.PathsPromoteRequest;
import org.commonjava.indy.promote.model.PathsPromoteResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class FoloTrackingAdjustListener {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    private FoloConfig foloConfig;
    @Inject
    private FoloRecord recordManager;
    @Inject
    private PromoteChangeManager promoteChangeManager;
    @Inject
    private StoreDataManager storeManager;

    public void onPromoteComplete(@Observes PromoteCompleteEvent event) {
        if (!this.foloConfig.isRecordingEnabled()) {
            this.logger.debug("Recording is disabled in monolith, ignoring PROMOTE COMPLETE");
            return;
        }
        this.logger.trace("Promote COMPLETE: {}", (Object)event);
        if (!this.foloConfig.isEnabled()) {
            return;
        }
        if (event instanceof PathsPromoteCompleteEvent) {
            this.handlePathsPromoteComplete(((PathsPromoteCompleteEvent)event).getPromoteResult());
        }
    }

    private void handlePathsPromoteComplete(PathsPromoteResult promoteResult) {
        String error = promoteResult.getError();
        if (error != null) {
            this.logger.trace("Error in promoteResult, skip adjust");
            return;
        }
        Set paths = promoteResult.getCompletedPaths();
        if (paths.isEmpty()) {
            this.logger.trace("No completedPaths, skip adjust");
            return;
        }
        PathsPromoteRequest req = promoteResult.getRequest();
        StoreKey source = req.getSource();
        StoreKey target = req.getTarget();
        TrackingKey trackingKey = this.getTrackingKey(source);
        if (trackingKey == null) {
            this.logger.trace("No tracking key found to: {}", (Object)source);
            return;
        }
        TrackedContent trackedContent = this.recordManager.get(trackingKey);
        if (trackedContent == null) {
            this.logger.trace("No sealed record found, trackingKey: {}", (Object)trackingKey);
            return;
        }
        this.adjustTrackedContent(trackedContent, source, target);
        this.recordManager.replaceTrackingRecord(trackedContent);
    }

    private void adjustTrackedContent(TrackedContent trackedContent, StoreKey source, StoreKey target) {
        Set uploads = trackedContent.getUploads();
        uploads.forEach(entry -> entry.setStoreKey(target));
    }

    private TrackingKey getTrackingKey(StoreKey source) {
        if (source.getType() == StoreType.hosted) {
            return new TrackingKey(this.promoteChangeManager.getTrackingIdFormatter().format(source));
        }
        return null;
    }
}

