/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.folo.change;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.commonjava.atlas.maven.ident.util.ArtifactPathInfo;
import org.commonjava.indy.IndyWorkflowException;
import org.commonjava.indy.content.ContentManager;
import org.commonjava.indy.data.IndyDataException;
import org.commonjava.indy.data.StoreDataManager;
import org.commonjava.indy.model.core.ArtifactStore;
import org.commonjava.indy.model.core.StoreKey;
import org.commonjava.maven.galley.event.FileStorageEvent;
import org.commonjava.maven.galley.model.ConcreteResource;
import org.commonjava.maven.galley.model.Transfer;
import org.commonjava.maven.galley.model.TransferOperation;
import org.commonjava.maven.galley.spi.cache.CacheProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class FoloPomDownloadListener {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    private ContentManager contentManager;
    @Inject
    private CacheProvider cacheProvider;
    @Inject
    private StoreDataManager storeManager;

    public void onFileUpload(@Observes FileStorageEvent event) {
        ArtifactStore store;
        TransferOperation op = event.getType();
        if (op != TransferOperation.DOWNLOAD) {
            this.logger.trace("Not a download transfer operation. No pom existence check performed.");
            return;
        }
        Transfer transfer = event.getTransfer();
        if (transfer == null) {
            this.logger.trace("No transfer. No pom existence check performed.");
            return;
        }
        String txfrPath = transfer.getPath();
        if (txfrPath.endsWith(".pom")) {
            this.logger.trace("This is a pom download.");
            return;
        }
        ArtifactPathInfo artPathInfo = ArtifactPathInfo.parse((String)txfrPath);
        if (artPathInfo == null) {
            this.logger.trace("Not an artifact download ({}). No pom existence check performed.", (Object)txfrPath);
            return;
        }
        String pomFilename = String.format("%s-%s.pom", artPathInfo.getArtifactId(), artPathInfo.getVersion());
        ConcreteResource pomResource = transfer.getResource().getParent().getChild(pomFilename);
        if (this.cacheProvider.exists(pomResource)) {
            this.logger.trace("Pom {} already exists.", (Object)this.cacheProvider.getFilePath(pomResource));
            return;
        }
        StoreKey storeKey = StoreKey.fromString((String)transfer.getLocation().getName());
        try {
            store = this.storeManager.getArtifactStore(storeKey);
        }
        catch (IndyDataException ex) {
            this.logger.error("Error retrieving artifactStore with key " + storeKey, (Throwable)ex);
            return;
        }
        try {
            this.logger.debug("Downloading POM as automatic response to associated artifact download: {}/{}", (Object)storeKey, (Object)pomResource.getPath());
            this.contentManager.retrieve(store, pomResource.getPath(), event.getEventMetadata());
        }
        catch (IndyWorkflowException ex) {
            this.logger.error("Error while retrieving pom artifact " + pomResource.getPath() + " from store " + store, (Throwable)ex);
            return;
        }
    }
}

