/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.folo.data;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.mapping.Mapper;
import com.datastax.driver.mapping.MappingManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.commonjava.indy.IndyWorkflowException;
import org.commonjava.indy.action.IndyLifecycleException;
import org.commonjava.indy.action.StartupAction;
import org.commonjava.indy.conf.IndyConfiguration;
import org.commonjava.indy.folo.conf.FoloConfig;
import org.commonjava.indy.folo.data.DtxTrackingRecord;
import org.commonjava.indy.folo.data.FoloContentException;
import org.commonjava.indy.folo.data.FoloRecord;
import org.commonjava.indy.folo.data.FoloStoreToCassandra;
import org.commonjava.indy.folo.model.TrackedContent;
import org.commonjava.indy.folo.model.TrackedContentEntry;
import org.commonjava.indy.folo.model.TrackingKey;
import org.commonjava.indy.subsys.cassandra.CassandraClient;
import org.commonjava.indy.subsys.cassandra.util.SchemaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@FoloStoreToCassandra
public class FoloRecordCassandra
implements FoloRecord,
StartupAction {
    private static final String DOWNLOADS = "DOWNLOAD";
    private static final String UPLOADS = "UPLOAD";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    CassandraClient cassandraClient;
    @Inject
    FoloConfig config;
    @Inject
    IndyConfiguration indyConfig;
    @Context
    UriInfo uriInfo;
    private Session session;
    private Mapper<DtxTrackingRecord> trackingMapper;
    private PreparedStatement getTrackingRecord;
    private PreparedStatement getTrackingKeys;
    private PreparedStatement getLegacyTrackingKeys;
    private PreparedStatement getTrackingRecordsByTrackingKey;
    private PreparedStatement getLegacyTrackingRecordsByTrackingKey;
    private PreparedStatement isTrackingRecordExist;
    private PreparedStatement deleteTrackingRecordsByTrackingKey;
    static final String TABLE_NAME = "records2";
    static final String LEGACY_TABLE_NAME = "records";

    private static String createFoloRecordsTable(String keyspace, String table) {
        return "CREATE TABLE IF NOT EXISTS " + keyspace + "." + table + " (tracking_key text,sealed boolean,store_key text,access_channel text,path text,origin_url text,local_url text,store_effect text,md5 text,sha256 text,sha1 text,size bigint,started bigint,timestamps set<bigint>,PRIMARY KEY ((tracking_key),store_key,path,store_effect));";
    }

    @PostConstruct
    public void initialize() {
        this.logger.info("-- Creating Cassandra Folo Records Keyspace and Tables");
        String foloCassandraKeyspace = this.config.getFoloCassandraKeyspace();
        this.session = this.cassandraClient.getSession(foloCassandraKeyspace);
        this.session.execute(SchemaUtils.getSchemaCreateKeyspace((String)foloCassandraKeyspace, (int)this.indyConfig.getKeyspaceReplicas()));
        this.session.execute(FoloRecordCassandra.createFoloRecordsTable(foloCassandraKeyspace, TABLE_NAME));
        this.session.execute(FoloRecordCassandra.createFoloRecordsTable(foloCassandraKeyspace, LEGACY_TABLE_NAME));
        MappingManager mappingManager = new MappingManager(this.session);
        this.trackingMapper = mappingManager.mapper(DtxTrackingRecord.class, foloCassandraKeyspace);
        this.getTrackingRecord = this.session.prepare("SELECT * FROM " + foloCassandraKeyspace + "." + TABLE_NAME + " WHERE tracking_key=? AND store_key=? AND path=? AND store_effect=?;");
        this.getTrackingKeys = this.session.prepare("SELECT distinct tracking_key FROM " + foloCassandraKeyspace + "." + TABLE_NAME + ";");
        this.getLegacyTrackingKeys = this.session.prepare("SELECT distinct tracking_key FROM " + foloCassandraKeyspace + "." + LEGACY_TABLE_NAME + ";");
        this.getTrackingRecordsByTrackingKey = this.session.prepare("SELECT * FROM " + foloCassandraKeyspace + "." + TABLE_NAME + " WHERE tracking_key=?;");
        this.getLegacyTrackingRecordsByTrackingKey = this.session.prepare("SELECT * FROM " + foloCassandraKeyspace + "." + LEGACY_TABLE_NAME + " WHERE tracking_key=?;");
        this.isTrackingRecordExist = this.session.prepare("SELECT count(*) FROM " + foloCassandraKeyspace + "." + TABLE_NAME + " WHERE tracking_key=?;");
        this.deleteTrackingRecordsByTrackingKey = this.session.prepare("DELETE FROM " + foloCassandraKeyspace + "." + TABLE_NAME + " WHERE tracking_key=?;");
        this.logger.info("-- Cassandra Folo Records Keyspace and Tables created");
    }

    @Override
    public boolean recordArtifact(TrackedContentEntry entry) throws FoloContentException, IndyWorkflowException {
        DtxTrackingRecord dtxTrackingRecord;
        Boolean state;
        String effect;
        String path;
        String storeKey;
        String buildId = entry.getTrackingKey().getId();
        BoundStatement bind = this.getTrackingRecord.bind(new Object[]{buildId, storeKey = entry.getStoreKey().toString(), path = entry.getPath(), effect = entry.getEffect().toString()});
        ResultSet trackingRecord = this.session.execute((Statement)bind);
        Row one = trackingRecord.one();
        if (one != null && (state = (dtxTrackingRecord = DtxTrackingRecord.fromCassandraRow(one)).getState()).booleanValue()) {
            throw new FoloContentException("Tracking record: {} is already sealed!", entry.getTrackingKey());
        }
        dtxTrackingRecord = new DtxTrackingRecord(entry);
        this.trackingMapper.save((Object)dtxTrackingRecord);
        return true;
    }

    @Override
    public void delete(TrackingKey key) {
        this.logger.info("Delete tracking records, tracking_id: {}", (Object)key.getId());
        BoundStatement bind = this.deleteTrackingRecordsByTrackingKey.bind(new Object[]{key.getId()});
        this.session.execute((Statement)bind);
    }

    @Override
    public void replaceTrackingRecord(TrackedContent record) {
        this.saveTrackedContentRecords(record);
    }

    @Override
    public boolean hasRecord(TrackingKey key) {
        BoundStatement bind = this.isTrackingRecordExist.bind(new Object[]{key});
        ResultSet result = this.session.execute((Statement)bind);
        Row row = result.one();
        boolean exists = false;
        if (row != null) {
            long count = (Long)row.get(0, Long.class);
            exists = count > 0L;
        }
        this.logger.trace("{} {}", (Object)key, (Object)(exists ? "exists" : "not exists"));
        return exists;
    }

    @Override
    public TrackedContent get(TrackingKey key) {
        List<DtxTrackingRecord> trackingRecords = this.getDtxTrackingRecordsFromDb(key);
        if (trackingRecords == null || trackingRecords.isEmpty()) {
            return null;
        }
        return this.transformDtxTrackingRecordToTrackingContent(key, trackingRecords);
    }

    @Override
    public TrackedContent seal(TrackingKey trackingKey) {
        List<DtxTrackingRecord> trackingRecords = this.getDtxTrackingRecordsFromDb(trackingKey);
        if (trackingRecords == null || trackingRecords.isEmpty()) {
            this.logger.debug("Tracking record: {} doesn't exist! Returning empty record.", (Object)trackingKey);
            return new TrackedContent(trackingKey, new HashSet(), new HashSet());
        }
        DtxTrackingRecord recordCheck = trackingRecords.get(0);
        if (recordCheck.getState().booleanValue()) {
            this.logger.debug("Tracking record: {} already sealed! Returning sealed record.", (Object)trackingKey);
            return this.transformDtxTrackingRecordToTrackingContent(trackingKey, trackingRecords);
        }
        this.logger.debug("Sealing record for: {}", (Object)trackingKey);
        for (DtxTrackingRecord record : trackingRecords) {
            record.setState(true);
            this.trackingMapper.save((Object)record);
        }
        return this.transformDtxTrackingRecordToTrackingContent(trackingKey, trackingRecords);
    }

    @Override
    public Set<TrackingKey> getInProgressTrackingKey() {
        throw new UnsupportedOperationException("Getting in-progress tracking keys are not supported by Cassandra Folo");
    }

    @Override
    public Set<TrackingKey> getSealedTrackingKey() {
        return this.getTrackingKeys();
    }

    @Override
    public Set<TrackedContent> getSealed() {
        HashSet<TrackedContent> trackedContents = new HashSet<TrackedContent>();
        Set<TrackingKey> sealedTrackingKeys = this.getSealedTrackingKey();
        for (TrackingKey trackingKey : sealedTrackingKeys) {
            List<DtxTrackingRecord> dtxTrackingRecordsFromDb = this.getDtxTrackingRecordsFromDb(trackingKey);
            TrackedContent trackedContent = this.transformDtxTrackingRecordToTrackingContent(trackingKey, dtxTrackingRecordsFromDb);
            trackedContents.add(trackedContent);
        }
        return trackedContents;
    }

    @Override
    public void addSealedRecord(TrackedContent record) {
        this.saveTrackedContentRecords(record);
    }

    public void start() throws IndyLifecycleException {
        this.logger.info("--- FoloRecordsCassandra starting up");
    }

    public int getStartupPriority() {
        return 0;
    }

    public String getId() {
        return "Folo2Cassandra";
    }

    private TrackedContent transformDtxTrackingRecordToTrackingContent(TrackingKey trackingKey, List<DtxTrackingRecord> trackingRecords) {
        ArrayList<TrackedContentEntry> records = new ArrayList<TrackedContentEntry>();
        for (DtxTrackingRecord record2 : trackingRecords) {
            records.add(DtxTrackingRecord.toTrackingContentEntry(record2));
        }
        Set uploads = records.stream().filter(record -> record.getEffect().toString().equals(UPLOADS)).collect(Collectors.toSet());
        Set downloads = records.stream().filter(record -> record.getEffect().toString().equals(DOWNLOADS)).collect(Collectors.toSet());
        TrackedContent trackedContent = new TrackedContent(trackingKey, uploads, downloads);
        return trackedContent;
    }

    private List<DtxTrackingRecord> getLegacyDtxTrackingRecordsFromDb(TrackingKey trackingKey) {
        BoundStatement bind = this.getLegacyTrackingRecordsByTrackingKey.bind(new Object[]{trackingKey.getId()});
        ResultSet execute = this.session.execute((Statement)bind);
        List rows = execute.all();
        return this.fetchRecordsFromRows(rows);
    }

    private List<DtxTrackingRecord> getDtxTrackingRecordsFromDb(TrackingKey trackingKey) {
        BoundStatement bind = this.getTrackingRecordsByTrackingKey.bind(new Object[]{trackingKey.getId()});
        ResultSet execute = this.session.execute((Statement)bind);
        List rows = execute.all();
        return this.fetchRecordsFromRows(rows);
    }

    private List<DtxTrackingRecord> fetchRecordsFromRows(List<Row> rows) {
        ArrayList<DtxTrackingRecord> trackingRecords = new ArrayList<DtxTrackingRecord>();
        for (Row next : rows) {
            DtxTrackingRecord dtxTrackingRecord = new DtxTrackingRecord();
            dtxTrackingRecord.setTrackingKey(next.getString("tracking_key"));
            dtxTrackingRecord.setState(next.getBool("sealed"));
            dtxTrackingRecord.setLocalUrl(next.getString("local_url"));
            dtxTrackingRecord.setOriginUrl(next.getString("origin_url"));
            dtxTrackingRecord.setTimestamps(next.getSet("timestamps", Long.class));
            dtxTrackingRecord.setPath(next.getString("path"));
            dtxTrackingRecord.setStoreEffect(next.getString("store_effect"));
            dtxTrackingRecord.setSha256(next.getString("sha256"));
            dtxTrackingRecord.setSha1(next.getString("sha1"));
            dtxTrackingRecord.setMd5(next.getString("md5"));
            dtxTrackingRecord.setSize(next.getLong("size"));
            dtxTrackingRecord.setStoreKey(next.getString("store_key"));
            dtxTrackingRecord.setAccessChannel(next.getString("access_channel"));
            trackingRecords.add(dtxTrackingRecord);
        }
        return trackingRecords;
    }

    private void saveTrackedContentRecords(TrackedContent record) {
        Set downloads = record.getDownloads();
        Set uploads = record.getUploads();
        TrackingKey key = record.getKey();
        for (TrackedContentEntry downloadEntry : downloads) {
            DtxTrackingRecord downloadRecord = DtxTrackingRecord.fromTrackedContentEntry(downloadEntry, true);
            this.trackingMapper.save((Object)downloadRecord);
        }
        for (TrackedContentEntry uploadEntry : uploads) {
            DtxTrackingRecord uploadRecord = DtxTrackingRecord.fromTrackedContentEntry(uploadEntry, true);
            this.trackingMapper.save((Object)uploadRecord);
        }
    }

    @Override
    public TrackedContent getLegacy(TrackingKey key) {
        List<DtxTrackingRecord> trackingRecords = this.getLegacyDtxTrackingRecordsFromDb(key);
        if (trackingRecords == null || trackingRecords.isEmpty()) {
            return null;
        }
        return this.transformDtxTrackingRecordToTrackingContent(key, trackingRecords);
    }

    @Override
    public Set<TrackingKey> getLegacyTrackingKeys() {
        BoundStatement statement = this.getLegacyTrackingKeys.bind();
        return this.getTrackingKeys(statement);
    }

    private Set<TrackingKey> getTrackingKeys() {
        BoundStatement statement = this.getTrackingKeys.bind();
        return this.getTrackingKeys(statement);
    }

    private Set<TrackingKey> getTrackingKeys(BoundStatement statement) {
        ResultSet resultSet = this.session.execute((Statement)statement);
        List all = resultSet.all();
        Iterator iterator = all.iterator();
        HashSet<TrackingKey> trackingKeys = new HashSet<TrackingKey>();
        while (iterator.hasNext()) {
            Row next = (Row)iterator.next();
            String tracking_key = next.getString("tracking_key");
            trackingKeys.add(new TrackingKey(tracking_key));
        }
        return trackingKeys.stream().collect(Collectors.toSet());
    }
}

